/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.common;

import java.util.Objects;
import java.util.function.IntPredicate;
import org.springframework.util.StringUtils;

public class Range {
    public static final String DEFAULT_SEPARATOR = ":";
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = Integer.MAX_VALUE;
    private static final Range UNBOUNDED = new Range(0, Integer.MAX_VALUE);
    private static final String VARIABLE = "*";
    private final int min;
    private final int max;
    private String separator = ":";

    private Range(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int getSpread() {
        return this.max - this.min + 1;
    }

    public boolean contains(int value) {
        return value >= this.min && value <= this.max;
    }

    public IntPredicate asPredicate() {
        return this::contains;
    }

    public int hashCode() {
        return Objects.hash(this.max, this.min);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        return this.max == other.max && this.min == other.min;
    }

    public String toString() {
        if (this.min == this.max) {
            return this.toString(this.min);
        }
        return this.min + this.separator + this.max;
    }

    private String toString(int value) {
        if (value == Integer.MAX_VALUE) {
            return VARIABLE;
        }
        return String.valueOf(value);
    }

    public static Range of(String string, String separator) {
        try {
            int pos = string.indexOf(separator);
            if (pos == -1) {
                return Range.of(Integer.parseInt(string));
            }
            int min = Range.min(string.substring(0, pos).trim());
            int max = Range.max(string.substring(pos + 1).trim());
            return Range.of(min, max);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid range. Range should be in the form 'int:int'", e);
        }
    }

    public static Range of(String string) {
        return Range.of(string, DEFAULT_SEPARATOR);
    }

    private static int min(String string) {
        if (StringUtils.hasLength((String)string)) {
            return Integer.parseInt(string);
        }
        return 0;
    }

    private static int max(String string) {
        if (StringUtils.hasLength((String)string) && !string.equals(VARIABLE)) {
            return Integer.parseInt(string);
        }
        return Integer.MAX_VALUE;
    }

    public static Range of(int value) {
        return new Range(value, value);
    }

    public static Range of(int min, int max) {
        return new Range(min, max);
    }

    public static Range from(int min) {
        return new Range(min, Integer.MAX_VALUE);
    }

    public static Range to(int max) {
        return new Range(0, max);
    }

    public static Range unbounded() {
        return UNBOUNDED;
    }
}

