/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class SetBlockingQueue<E>
implements BlockingQueue<E> {
    private final HashSet<E> set = new HashSet();
    private final BlockingQueue<E> delegate;
    private final int capacity;

    public SetBlockingQueue(BlockingQueue<E> delegate, int capacity) {
        this.delegate = delegate;
        this.capacity = capacity;
    }

    @Override
    public E remove() {
        Object element = this.delegate.remove();
        this.set.remove(element);
        return element;
    }

    @Override
    public E poll() {
        Object element = this.delegate.poll();
        if (element != null) {
            this.set.remove(element);
        }
        return element;
    }

    @Override
    public E element() {
        return this.delegate.element();
    }

    @Override
    public E peek() {
        return this.delegate.peek();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (this.set.addAll(c)) {
            return this.delegate.addAll(c);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.set.removeAll(c)) {
            return this.delegate.removeAll(c);
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.set.retainAll(c)) {
            return this.delegate.retainAll(c);
        }
        return false;
    }

    @Override
    public void clear() {
        this.set.clear();
        this.delegate.clear();
    }

    @Override
    public boolean add(E e) {
        if (this.set.add(e)) {
            return this.delegate.add(e);
        }
        return true;
    }

    @Override
    public boolean offer(E e) {
        if (this.set.add(e)) {
            return this.delegate.offer(e);
        }
        return true;
    }

    @Override
    public void put(E e) throws InterruptedException {
        if (this.set.add(e)) {
            this.delegate.put(e);
        }
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.set.add(e)) {
            return this.delegate.offer(e, timeout, unit);
        }
        return true;
    }

    @Override
    public E take() throws InterruptedException {
        E element = this.delegate.take();
        this.set.remove(element);
        return element;
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        E element = this.delegate.poll(timeout, unit);
        if (element != null) {
            this.set.remove(element);
        }
        return element;
    }

    @Override
    public int remainingCapacity() {
        return this.capacity - this.delegate.size();
    }

    @Override
    public boolean remove(Object o) {
        if (this.set.remove(o)) {
            return this.delegate.remove(o);
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        ArrayList intermediary = new ArrayList();
        int count = this.delegate.drainTo(intermediary);
        this.set.removeAll(intermediary);
        c.addAll(intermediary);
        return count;
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        ArrayList intermediary = new ArrayList();
        int count = this.delegate.drainTo(intermediary, maxElements);
        this.set.removeAll(intermediary);
        c.addAll(intermediary);
        return count;
    }
}

