/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.common;

import io.lettuce.core.GeoValue;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;

public class ToGeoValueFunction<V, T>
implements Function<T, GeoValue<V>> {
    private final Function<T, V> memberConverter;
    private final ToDoubleFunction<T> longitudeConverter;
    private final ToDoubleFunction<T> latitudeConverter;

    public ToGeoValueFunction(Function<T, V> member, ToDoubleFunction<T> longitude, ToDoubleFunction<T> latitude) {
        this.memberConverter = member;
        this.longitudeConverter = longitude;
        this.latitudeConverter = latitude;
    }

    @Override
    public GeoValue<V> apply(T t) {
        double longitude = this.longitudeConverter.applyAsDouble(t);
        double latitude = this.latitudeConverter.applyAsDouble(t);
        return GeoValue.just((double)longitude, (double)latitude, this.memberConverter.apply(t));
    }
}

