/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.common;

import io.lettuce.core.ScoredValue;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;

public class ToScoredValueFunction<V, T>
implements Function<T, ScoredValue<V>> {
    private final Function<T, V> member;
    private final ToDoubleFunction<T> score;

    public ToScoredValueFunction(Function<T, V> member, ToDoubleFunction<T> score) {
        this.member = member;
        this.score = score;
    }

    @Override
    public ScoredValue<V> apply(T source) {
        return ScoredValue.just((double)this.score.applyAsDouble(source), this.member.apply(source));
    }
}

