/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.gen;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.redis.lettucemod.timeseries.Sample;
import com.redis.spring.batch.common.DataType;
import com.redis.spring.batch.common.KeyValue;
import com.redis.spring.batch.common.Range;
import com.redis.spring.batch.gen.CollectionOptions;
import com.redis.spring.batch.gen.MapOptions;
import com.redis.spring.batch.gen.StreamOptions;
import com.redis.spring.batch.gen.StringOptions;
import com.redis.spring.batch.gen.TimeSeriesOptions;
import com.redis.spring.batch.gen.ZsetOptions;
import io.lettuce.core.ScoredValue;
import io.lettuce.core.StreamMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.util.ClassUtils;

public class GeneratorItemReader
extends AbstractItemCountingItemStreamItemReader<KeyValue<String>> {
    public static final String DEFAULT_KEYSPACE = "gen";
    public static final String DEFAULT_KEY_SEPARATOR = ":";
    private static final DataType[] DEFAULT_TYPES = DataType.values();
    public static final Range DEFAULT_KEY_RANGE = Range.from(1);
    private static final int LEFT_LIMIT = 48;
    private static final int RIGHT_LIMIT = 122;
    private final ObjectMapper mapper = new ObjectMapper();
    private static final Random random = new Random();
    private String keySeparator = ":";
    private String keyspace = "gen";
    private Range keyRange = DEFAULT_KEY_RANGE;
    private Range expiration;
    private MapOptions hashOptions = new MapOptions();
    private StreamOptions streamOptions = new StreamOptions();
    private TimeSeriesOptions timeSeriesOptions = new TimeSeriesOptions();
    private MapOptions jsonOptions = new MapOptions();
    private CollectionOptions listOptions = new CollectionOptions();
    private CollectionOptions setOptions = new CollectionOptions();
    private StringOptions stringOptions = new StringOptions();
    private ZsetOptions zsetOptions = new ZsetOptions();
    private List<DataType> types = GeneratorItemReader.defaultTypes();
    private boolean open;

    public GeneratorItemReader() {
        this.setName(ClassUtils.getShortName(((Object)((Object)this)).getClass()));
    }

    public static List<DataType> defaultTypes() {
        return Arrays.asList(DEFAULT_TYPES);
    }

    public String getKeySeparator() {
        return this.keySeparator;
    }

    public void setKeySeparator(String keySeparator) {
        this.keySeparator = keySeparator;
    }

    public void setKeyRange(Range range) {
        this.keyRange = range;
    }

    public Range getKeyRange() {
        return this.keyRange;
    }

    public Range getExpiration() {
        return this.expiration;
    }

    public MapOptions getHashOptions() {
        return this.hashOptions;
    }

    public StreamOptions getStreamOptions() {
        return this.streamOptions;
    }

    public TimeSeriesOptions getTimeSeriesOptions() {
        return this.timeSeriesOptions;
    }

    public MapOptions getJsonOptions() {
        return this.jsonOptions;
    }

    public CollectionOptions getListOptions() {
        return this.listOptions;
    }

    public CollectionOptions getSetOptions() {
        return this.setOptions;
    }

    public StringOptions getStringOptions() {
        return this.stringOptions;
    }

    public ZsetOptions getZsetOptions() {
        return this.zsetOptions;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public List<DataType> getTypes() {
        return this.types;
    }

    public void setExpiration(Range range) {
        this.expiration = range;
    }

    public void setHashOptions(MapOptions options) {
        this.hashOptions = options;
    }

    public void setStreamOptions(StreamOptions options) {
        this.streamOptions = options;
    }

    public void setJsonOptions(MapOptions options) {
        this.jsonOptions = options;
    }

    public void setTimeSeriesOptions(TimeSeriesOptions options) {
        this.timeSeriesOptions = options;
    }

    public void setListOptions(CollectionOptions options) {
        this.listOptions = options;
    }

    public void setSetOptions(CollectionOptions options) {
        this.setOptions = options;
    }

    public void setZsetOptions(ZsetOptions options) {
        this.zsetOptions = options;
    }

    public void setStringOptions(StringOptions options) {
        this.stringOptions = options;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public void setTypes(DataType ... types) {
        this.setTypes(Arrays.asList(types));
    }

    public void setTypes(List<DataType> types) {
        this.types = types;
    }

    private String key() {
        int index = this.keyRange.getMin() + this.index() % this.keyRange.getSpread();
        return this.key(index);
    }

    public String key(int index) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.keyspace);
        builder.append(this.keySeparator);
        builder.append(index);
        return builder.toString();
    }

    private Object value(DataType type) throws JsonProcessingException {
        switch (type) {
            case HASH: {
                return this.map(this.hashOptions);
            }
            case LIST: {
                return this.members(this.listOptions);
            }
            case SET: {
                return new HashSet<String>(this.members(this.setOptions));
            }
            case STREAM: {
                return this.streamMessages();
            }
            case STRING: {
                return this.string(this.stringOptions.getLength());
            }
            case ZSET: {
                return this.zset();
            }
            case JSON: {
                return this.mapper.writeValueAsString(this.map(this.jsonOptions));
            }
            case TIMESERIES: {
                return this.samples();
            }
        }
        return null;
    }

    private List<Sample> samples() {
        ArrayList<Sample> samples = new ArrayList<Sample>();
        long size = this.randomLong(this.timeSeriesOptions.getSampleCount());
        long startTime = this.timeSeriesStartTime();
        int index = 0;
        while ((long)index < size) {
            long time = startTime + (long)this.index() + (long)index;
            samples.add(Sample.of((long)time, (double)random.nextDouble()));
            ++index;
        }
        return samples;
    }

    private long timeSeriesStartTime() {
        return this.timeSeriesOptions.getStartTime().toEpochMilli();
    }

    private List<ScoredValue<String>> zset() {
        return this.members(this.zsetOptions).stream().map(this::scoredValue).collect(Collectors.toList());
    }

    private ScoredValue<String> scoredValue(String value) {
        double score = this.randomDouble(this.zsetOptions.getScore());
        return ScoredValue.just((double)score, (Object)value);
    }

    private Collection<StreamMessage<String, String>> streamMessages() {
        String key = this.key();
        ArrayList<StreamMessage<String, String>> messages = new ArrayList<StreamMessage<String, String>>();
        int elementIndex = 0;
        while ((long)elementIndex < this.randomLong(this.streamOptions.getMessageCount())) {
            messages.add((StreamMessage<String, String>)new StreamMessage((Object)key, null, this.map(this.streamOptions.getBodyOptions())));
            ++elementIndex;
        }
        return messages;
    }

    private Map<String, String> map(MapOptions options) {
        HashMap<String, String> hash = new HashMap<String, String>();
        int index = 0;
        while ((long)index < this.randomLong(options.getFieldCount())) {
            int fieldIndex = index + 1;
            hash.put("field" + fieldIndex, this.string(options.getFieldLength()));
            ++index;
        }
        return hash;
    }

    private String string(Range range) {
        long length = this.randomLong(range);
        return GeneratorItemReader.string(length);
    }

    public static String string(long length) {
        return random.ints(48, 123).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).limit(length).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    private List<String> members(CollectionOptions options) {
        ArrayList<String> members = new ArrayList<String>();
        int spread = options.getMemberRange().getMax() - options.getMemberRange().getMin() + 1;
        int index = 0;
        while ((long)index < this.randomLong(options.getMemberCount())) {
            int memberId = options.getMemberRange().getMin() + index % spread;
            members.add(String.valueOf(memberId));
            ++index;
        }
        return members;
    }

    private long randomLong(Range range) {
        if (range.getMin() == range.getMax()) {
            return range.getMin();
        }
        return ThreadLocalRandom.current().nextLong(range.getMin(), range.getMax());
    }

    private double randomDouble(Range range) {
        if (range.getMin() == range.getMax()) {
            return range.getMin();
        }
        return ThreadLocalRandom.current().nextDouble(range.getMin(), range.getMax());
    }

    protected KeyValue<String> doRead() {
        KeyValue<String> struct = new KeyValue<String>();
        struct.setKey(this.key());
        DataType type = this.types.get(this.index() % this.types.size());
        struct.setType(type);
        try {
            struct.setValue(this.value(type));
        }
        catch (JsonProcessingException e) {
            throw new ItemStreamException("Could not read value", (Throwable)e);
        }
        if (this.expiration != null) {
            struct.setTtl(this.ttl());
        }
        return struct;
    }

    private long ttl() {
        return System.currentTimeMillis() + this.randomLong(this.expiration);
    }

    private int index() {
        return this.getCurrentItemCount() - 1;
    }

    protected void doOpen() {
        this.open = true;
    }

    protected void doClose() {
        this.open = false;
    }

    public boolean isOpen() {
        return this.open;
    }
}

