/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.reader;

import com.redis.spring.batch.common.Operation;
import com.redis.spring.batch.util.CodecUtils;
import com.redis.spring.batch.util.ConnectionUtils;
import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import io.lettuce.core.api.async.RedisScriptingAsyncCommands;
import io.lettuce.core.codec.RedisCodec;
import java.util.List;
import java.util.function.Function;

public class Evalsha<K, V, T>
implements Operation<K, V, T, List<Object>> {
    private final String digest;
    private final Function<String, V> stringValueFunction;
    private Function<T, K> keyFunction;
    private Function<T, V[]> argsFunction;

    public Evalsha(String filename, AbstractRedisClient client, RedisCodec<K, V> codec) {
        this.digest = ConnectionUtils.loadScript(client, filename);
        this.stringValueFunction = CodecUtils.stringValueFunction(codec);
    }

    public void setKeys(K key) {
        this.setKeyFunction(t -> key);
    }

    public void setKeyFunction(Function<T, K> function) {
        this.keyFunction = function;
    }

    public void setArgsFunction(Function<T, V[]> function) {
        this.argsFunction = function;
    }

    public void setArgs(Object ... args) {
        Object[] encodedArgs = new Object[args.length];
        for (int index = 0; index < args.length; ++index) {
            encodedArgs[index] = this.stringValueFunction.apply(String.valueOf(args[index]));
        }
        this.setArgsFunction(t -> encodedArgs);
    }

    @Override
    public RedisFuture<List<Object>> execute(BaseRedisAsyncCommands<K, V> commands, T item) {
        Object[] keys = new Object[]{this.keyFunction.apply(item)};
        Object[] args = this.argsFunction.apply(item);
        return ((RedisScriptingAsyncCommands)commands).evalsha(this.digest, ScriptOutputType.MULTI, keys, args);
    }
}

