/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.reader;

import com.redis.spring.batch.common.DataType;
import com.redis.spring.batch.common.KeyComparison;
import com.redis.spring.batch.common.KeyValue;
import com.redis.spring.batch.common.OperationValueReader;
import io.lettuce.core.StreamMessage;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.util.CollectionUtils;

public class KeyComparisonValueReader
implements ItemProcessor<List<String>, List<KeyComparison>>,
ItemStream {
    public static final Duration DEFAULT_TTL_TOLERANCE = Duration.ofMillis(100L);
    private final OperationValueReader<String, String, String, KeyValue<String>> source;
    private ItemProcessor<String, String> keyProcessor;
    private final OperationValueReader<String, String, String, KeyValue<String>> target;
    private ItemProcessor<KeyValue<String>, KeyValue<String>> processor;
    private Duration ttlTolerance = DEFAULT_TTL_TOLERANCE;
    private boolean compareStreamMessageIds;

    public KeyComparisonValueReader(OperationValueReader<String, String, String, KeyValue<String>> source, OperationValueReader<String, String, String, KeyValue<String>> target) {
        this.source = source;
        this.target = target;
    }

    public void setKeyProcessor(ItemProcessor<String, String> processor) {
        this.keyProcessor = processor;
    }

    public void setProcessor(ItemProcessor<KeyValue<String>, KeyValue<String>> processor) {
        this.processor = processor;
    }

    public void setTtlTolerance(Duration ttlTolerance) {
        this.ttlTolerance = ttlTolerance;
    }

    public void setCompareStreamMessageIds(boolean enable) {
        this.compareStreamMessageIds = enable;
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        if (this.source instanceof ItemStream) {
            this.source.open(executionContext);
        }
        if (this.processor instanceof ItemStream) {
            ((ItemStream)this.processor).open(executionContext);
        }
        if (this.target instanceof ItemStream) {
            this.target.open(executionContext);
        }
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        if (this.source instanceof ItemStream) {
            this.source.update(executionContext);
        }
        if (this.processor instanceof ItemStream) {
            ((ItemStream)this.processor).update(executionContext);
        }
        if (this.target instanceof ItemStream) {
            this.target.update(executionContext);
        }
    }

    public void close() throws ItemStreamException {
        if (this.source instanceof ItemStream) {
            this.source.close();
        }
        if (this.processor instanceof ItemStream) {
            ((ItemStream)this.processor).close();
        }
        if (this.target instanceof ItemStream) {
            this.target.close();
        }
    }

    public List<KeyComparison> process(List<String> keys) throws Exception {
        List<String> processedKeys = this.processKeys(keys);
        List<KeyValue<String>> sourceItems = this.source.process(processedKeys);
        if (CollectionUtils.isEmpty(sourceItems)) {
            return Collections.emptyList();
        }
        List<KeyValue<String>> items = this.processValues(sourceItems);
        List targetKeys = items.stream().map(KeyValue::getKey).collect(Collectors.toList());
        List targetItems = this.target.process(targetKeys);
        ArrayList<KeyComparison> comparisons = new ArrayList<KeyComparison>();
        if (CollectionUtils.isEmpty(items)) {
            throw new IllegalStateException("No source items found");
        }
        if (CollectionUtils.isEmpty(targetItems)) {
            throw new IllegalStateException("No target items found");
        }
        for (int index = 0; index < items.size(); ++index) {
            KeyComparison comparison = new KeyComparison();
            comparison.setSource(items.get(index));
            if (index < targetItems.size()) {
                comparison.setTarget((KeyValue)targetItems.get(index));
            }
            comparison.setStatus(this.status(comparison));
            comparisons.add(comparison);
        }
        return comparisons;
    }

    private List<KeyValue<String>> processValues(List<KeyValue<String>> values) throws Exception {
        if (this.processor == null) {
            return values;
        }
        ArrayList<KeyValue<String>> processedValues = new ArrayList<KeyValue<String>>(values.size());
        for (KeyValue<String> value : values) {
            KeyValue processedValue = (KeyValue)this.processor.process(value);
            if (processedValue == null) continue;
            processedValues.add(processedValue);
        }
        return processedValues;
    }

    private List<String> processKeys(List<String> keys) throws Exception {
        if (this.keyProcessor == null) {
            return keys;
        }
        ArrayList<String> processedKeys = new ArrayList<String>(keys.size());
        for (String key : keys) {
            String processedKey = (String)this.keyProcessor.process((Object)key);
            if (processedKey == null) continue;
            processedKeys.add(processedKey);
        }
        return processedKeys;
    }

    private KeyComparison.Status status(KeyComparison comparison) {
        long delta;
        KeyValue<String> sourceEntry = comparison.getSource();
        KeyValue<String> targetEntry = comparison.getTarget();
        if (targetEntry == null) {
            if (sourceEntry == null) {
                return KeyComparison.Status.OK;
            }
            return KeyComparison.Status.MISSING;
        }
        if (!targetEntry.exists() && sourceEntry.exists()) {
            return KeyComparison.Status.MISSING;
        }
        if (targetEntry.getType() != sourceEntry.getType()) {
            return KeyComparison.Status.TYPE;
        }
        if (!this.valueEquals(sourceEntry, targetEntry)) {
            return KeyComparison.Status.VALUE;
        }
        if (sourceEntry.getTtl() != targetEntry.getTtl() && (delta = Math.abs(sourceEntry.getTtl() - targetEntry.getTtl())) > this.ttlTolerance.toMillis()) {
            return KeyComparison.Status.TTL;
        }
        return KeyComparison.Status.OK;
    }

    private boolean valueEquals(KeyValue<String> source, KeyValue<String> target) {
        if (source.getType() == DataType.STREAM) {
            return this.streamEquals((Collection)source.getValue(), (Collection)target.getValue());
        }
        return Objects.deepEquals(source.getValue(), target.getValue());
    }

    private boolean streamEquals(Collection<StreamMessage> source, Collection<StreamMessage> target) {
        if (CollectionUtils.isEmpty(source)) {
            return CollectionUtils.isEmpty(target);
        }
        if (source.size() != target.size()) {
            return false;
        }
        Iterator<StreamMessage> sourceIterator = source.iterator();
        Iterator<StreamMessage> targetIterator = target.iterator();
        while (sourceIterator.hasNext()) {
            StreamMessage targetMessage;
            if (!targetIterator.hasNext()) {
                return false;
            }
            StreamMessage sourceMessage = sourceIterator.next();
            if (this.streamMessageEquals(sourceMessage, targetMessage = targetIterator.next())) continue;
            return false;
        }
        return true;
    }

    private boolean streamMessageEquals(StreamMessage sourceMessage, StreamMessage targetMessage) {
        if (!Objects.equals(sourceMessage.getStream(), targetMessage.getStream())) {
            return false;
        }
        if (this.compareStreamMessageIds && !Objects.equals(sourceMessage.getId(), targetMessage.getId())) {
            return false;
        }
        Map sourceBody = sourceMessage.getBody();
        Map targetBody = targetMessage.getBody();
        if (CollectionUtils.isEmpty((Map)sourceBody)) {
            return CollectionUtils.isEmpty((Map)targetBody);
        }
        return sourceBody.equals(targetBody);
    }
}

