/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.reader;

import com.redis.lettucemod.api.StatefulRedisModulesConnection;
import com.redis.spring.batch.reader.KeyItemReader;
import com.redis.spring.batch.util.ConnectionUtils;
import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.KeyScanArgs;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanIterator;
import io.lettuce.core.api.sync.RedisKeyCommands;
import io.lettuce.core.codec.RedisCodec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.support.AbstractItemStreamItemReader;
import org.springframework.util.ClassUtils;

public class KeyScanItemReader<K>
extends AbstractItemStreamItemReader<K>
implements KeyItemReader<K> {
    private final Log log = LogFactory.getLog(this.getClass());
    private final AbstractRedisClient client;
    private final RedisCodec<K, ?> codec;
    private ReadFrom readFrom;
    private long limit;
    private String match;
    private String type;
    private StatefulRedisModulesConnection<K, ?> connection;
    private ScanIterator<K> iterator;
    private String name;

    public KeyScanItemReader(AbstractRedisClient client, RedisCodec<K, ?> codec) {
        this.setName(ClassUtils.getShortName(this.getClass()));
        this.client = client;
        this.codec = codec;
    }

    public void setName(String name) {
        super.setName(name);
        this.name = name;
    }

    public void setReadFrom(ReadFrom readFrom) {
        this.readFrom = readFrom;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public void setMatch(String match) {
        this.match = match;
    }

    public void setType(String type) {
        this.type = type;
    }

    public synchronized void open(ExecutionContext executionContext) {
        super.open(executionContext);
        if (this.iterator == null) {
            this.log.debug((Object)String.format("Opening %s", this.name));
            this.connection = ConnectionUtils.connection(this.client, this.codec, this.readFrom);
            this.iterator = ScanIterator.scan((RedisKeyCommands)((RedisKeyCommands)ConnectionUtils.sync(this.connection)), (ScanArgs)this.scanArgs());
            this.log.debug((Object)String.format("Opened %s", this.name));
        }
    }

    @Override
    public boolean isOpen() {
        return this.iterator != null;
    }

    private KeyScanArgs scanArgs() {
        KeyScanArgs args = new KeyScanArgs();
        if (this.limit > 0L) {
            args.limit(this.limit);
        }
        if (this.match != null) {
            args.match(this.match);
        }
        if (this.type != null) {
            args.type(this.type);
        }
        return args;
    }

    public K read() {
        if (this.iterator.hasNext()) {
            return (K)this.iterator.next();
        }
        return null;
    }

    public synchronized void close() {
        if (this.iterator != null) {
            this.log.debug((Object)String.format("Closing %s", this.name));
            this.connection.close();
            this.iterator = null;
            this.log.debug((Object)String.format("Closed %s", this.name));
        }
        super.close();
    }
}

