/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.reader;

import com.redis.spring.batch.common.DataType;
import com.redis.spring.batch.common.KeyValue;
import com.redis.spring.batch.common.Operation;
import com.redis.spring.batch.reader.MappingRedisFuture;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import io.lettuce.core.api.async.RedisKeyAsyncCommands;

public class KeyTypeReadOperation<K, V>
implements Operation<K, V, K, KeyValue<K>> {
    @Override
    public RedisFuture<KeyValue<K>> execute(BaseRedisAsyncCommands<K, V> commands, K key) {
        RedisFuture future = ((RedisKeyAsyncCommands)commands).type(key);
        return new MappingRedisFuture<KeyValue, String>(future.toCompletableFuture(), t -> this.keyValue(key, (String)t));
    }

    private KeyValue<K> keyValue(K key, String type) {
        KeyValue<K> keyValue = new KeyValue<K>();
        keyValue.setKey(key);
        keyValue.setType(DataType.of(type));
        return keyValue;
    }
}

