/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.reader;

import com.redis.spring.batch.RedisItemReader;
import com.redis.spring.batch.common.KeyValue;
import com.redis.spring.batch.common.Operation;
import com.redis.spring.batch.common.OperationValueReader;
import com.redis.spring.batch.common.SimpleBatchOperation;
import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.codec.RedisCodec;
import org.springframework.util.unit.DataSize;

public abstract class KeyValueItemReader<K, V>
extends RedisItemReader<K, V, KeyValue<K>> {
    public static final DataSize DEFAULT_MEMORY_USAGE_LIMIT = DataSize.ofBytes((long)0L);
    public static final int DEFAULT_MEMORY_USAGE_SAMPLES = 5;
    public static final int DEFAULT_POOL_SIZE = 8;
    private int poolSize = 8;
    protected DataSize memLimit = DEFAULT_MEMORY_USAGE_LIMIT;
    protected int memSamples = 5;

    public void setMemoryUsageLimit(DataSize limit) {
        this.memLimit = limit;
    }

    public void setMemoryUsageSamples(int samples) {
        this.memSamples = samples;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    protected KeyValueItemReader(AbstractRedisClient client, RedisCodec<K, V> codec) {
        super(client, codec);
    }

    protected OperationValueReader<K, V, K, KeyValue<K>> valueReader() {
        return this.operationValueReader();
    }

    public OperationValueReader<K, V, K, KeyValue<K>> operationValueReader() {
        SimpleBatchOperation<K, V, K, KeyValue<K>> operation = new SimpleBatchOperation<K, V, K, KeyValue<K>>(this.operation());
        OperationValueReader executor = new OperationValueReader(this.getClient(), this.getCodec(), operation);
        executor.setPoolSize(this.poolSize);
        executor.setReadFrom(this.getReadFrom());
        return executor;
    }

    protected abstract Operation<K, V, K, KeyValue<K>> operation();
}

