/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.reader;

import io.lettuce.core.RedisFuture;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class MappingRedisFuture<T, S>
extends CompletableFuture<T>
implements RedisFuture<T> {
    private final CountDownLatch latch = new CountDownLatch(1);

    public MappingRedisFuture(CompletionStage<S> completionStage, Function<S, T> converter) {
        completionStage.thenAccept((? super T v) -> this.complete(converter.apply(v))).exceptionally((Throwable throwable) -> {
            this.completeExceptionally((Throwable)throwable);
            return null;
        });
    }

    @Override
    public boolean complete(T value) {
        boolean result = super.complete(value);
        this.latch.countDown();
        return result;
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        boolean value = super.completeExceptionally(ex);
        this.latch.countDown();
        return value;
    }

    public String getError() {
        return null;
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.latch.await(timeout, unit);
    }
}

