/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.reader;

import com.redis.spring.batch.reader.AbstractKeyspaceNotificationPublisher;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.cluster.pubsub.RedisClusterPubSubListener;
import io.lettuce.core.cluster.pubsub.StatefulRedisClusterPubSubConnection;
import io.lettuce.core.cluster.pubsub.api.sync.NodeSelectionPubSubCommands;

public class RedisClusterKeyspaceNotificationPublisher
extends AbstractKeyspaceNotificationPublisher
implements RedisClusterPubSubListener<String, String> {
    private final RedisClusterClient client;
    private final String pattern;
    private StatefulRedisClusterPubSubConnection<String, String> connection;

    public RedisClusterKeyspaceNotificationPublisher(RedisClusterClient client, String pattern) {
        this.client = client;
        this.pattern = pattern;
    }

    @Override
    public void open() {
        this.connection = this.client.connectPubSub();
        this.connection.setNodeMessagePropagation(true);
        this.connection.addListener((RedisClusterPubSubListener)this);
        ((NodeSelectionPubSubCommands)this.connection.sync().upstream().commands()).psubscribe((Object[])new String[]{this.pattern});
    }

    @Override
    public void close() {
        ((NodeSelectionPubSubCommands)this.connection.sync().upstream().commands()).punsubscribe((Object[])new String[]{this.pattern});
        this.connection.removeListener((RedisClusterPubSubListener)this);
        this.connection.close();
    }

    public void message(RedisClusterNode node, String channel, String message) {
    }

    public void message(RedisClusterNode node, String pattern, String channel, String message) {
        this.notification(channel, message);
    }

    public void subscribed(RedisClusterNode node, String channel, long count) {
    }

    public void psubscribed(RedisClusterNode node, String pattern, long count) {
    }

    public void unsubscribed(RedisClusterNode node, String channel, long count) {
    }

    public void punsubscribed(RedisClusterNode node, String pattern, long count) {
    }
}

