/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.reader;

import com.redis.spring.batch.reader.AbstractKeyspaceNotificationPublisher;
import io.lettuce.core.RedisClient;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;

public class RedisKeyspaceNotificationPublisher
extends AbstractKeyspaceNotificationPublisher
implements RedisPubSubListener<String, String> {
    private final RedisClient client;
    private final String pattern;
    private StatefulRedisPubSubConnection<String, String> connection;

    public RedisKeyspaceNotificationPublisher(RedisClient client, String pattern) {
        this.client = client;
        this.pattern = pattern;
    }

    @Override
    public void open() {
        this.connection = this.client.connectPubSub();
        this.connection.addListener((RedisPubSubListener)this);
        this.connection.sync().psubscribe((Object[])new String[]{this.pattern});
    }

    @Override
    public void close() {
        this.connection.sync().punsubscribe((Object[])new String[]{this.pattern});
        this.connection.removeListener((RedisPubSubListener)this);
        this.connection.close();
    }

    public void message(String channel, String message) {
    }

    public void message(String pattern, String channel, String message) {
        this.notification(channel, message);
    }

    public void subscribed(String channel, long count) {
    }

    public void psubscribed(String pattern, long count) {
    }

    public void unsubscribed(String channel, long count) {
    }

    public void punsubscribed(String pattern, long count) {
    }
}

