/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.reader;

import com.redis.spring.batch.util.ConnectionUtils;
import com.redis.spring.batch.util.Predicates;
import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.async.RedisScriptingAsyncCommands;
import io.lettuce.core.api.sync.BaseRedisCommands;
import io.lettuce.core.api.sync.RedisServerCommands;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import org.springframework.util.StringUtils;

public class ScanSizeEstimator
implements LongSupplier {
    public static final long UNKNOWN_SIZE = -1L;
    public static final int DEFAULT_SAMPLES = 100;
    private static final String LUA_FILE = "randomkeytype.lua";
    private final AbstractRedisClient client;
    private String scanMatch;
    private String scanType;
    private int samples = 100;

    public ScanSizeEstimator(AbstractRedisClient client) {
        this.client = client;
    }

    public String getScanMatch() {
        return this.scanMatch;
    }

    public void setScanMatch(String match) {
        this.scanMatch = match;
    }

    public int getSamples() {
        return this.samples;
    }

    public void setSamples(int samples) {
        this.samples = samples;
    }

    public void setScanType(String type) {
        this.scanType = type;
    }

    public String getScanType() {
        return this.scanType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAsLong() {
        StatefulConnection<String, String> connection = ConnectionUtils.supplier(this.client).get();
        BaseRedisCommands sync = (BaseRedisCommands)ConnectionUtils.sync(connection);
        Long dbsize = ((RedisServerCommands)sync).dbsize();
        if (dbsize == null) {
            return -1L;
        }
        if (!StringUtils.hasLength((String)this.scanMatch) && !StringUtils.hasLength((String)this.scanType)) {
            return dbsize;
        }
        String digest = ConnectionUtils.loadScript(this.client, LUA_FILE);
        RedisScriptingAsyncCommands commands = (RedisScriptingAsyncCommands)ConnectionUtils.async(connection);
        try {
            connection.setAutoFlushCommands(false);
            ArrayList<RedisFuture> futures = new ArrayList<RedisFuture>();
            for (int index = 0; index < this.samples; ++index) {
                futures.add(commands.evalsha(digest, ScriptOutputType.MULTI, (Object[])new String[0]));
            }
            connection.flushCommands();
            Predicate<String> matchPredicate = Predicates.glob(this.scanMatch);
            Predicate<String> typePredicate = this.typePredicate();
            int total = 0;
            int matchCount = 0;
            for (RedisFuture future : futures) {
                List result = (List)future.get(connection.getTimeout().toMillis(), TimeUnit.MILLISECONDS);
                if (result.size() != 2) continue;
                String key = (String)result.get(0);
                String keyType = (String)result.get(1);
                ++total;
                if (!matchPredicate.test(key) || !typePredicate.test(keyType)) continue;
                ++matchCount;
            }
            double matchRate = total == 0 ? 0.0 : (double)matchCount / (double)total;
            long l = Math.round((double)dbsize.longValue() * matchRate);
            return l;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception exception) {
        }
        finally {
            connection.setAutoFlushCommands(true);
        }
        return -1L;
    }

    private Predicate<String> typePredicate() {
        if (!StringUtils.hasLength((String)this.scanType)) {
            return Predicates.isTrue();
        }
        return this.scanType::equalsIgnoreCase;
    }
}

