/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.reader;

import com.redis.lettucemod.timeseries.Sample;
import com.redis.spring.batch.common.KeyValue;
import com.redis.spring.batch.util.CodecUtils;
import io.lettuce.core.ScoredValue;
import io.lettuce.core.StreamMessage;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public class StructPostOperator<K, V>
implements UnaryOperator<KeyValue<K>> {
    private final Function<V, String> toStringValueFunction;

    public StructPostOperator(RedisCodec<K, V> codec) {
        this.toStringValueFunction = CodecUtils.toStringValueFunction(codec);
    }

    @Override
    public KeyValue<K> apply(KeyValue<K> t) {
        if (t != null) {
            t.setValue(this.value(t));
        }
        return t;
    }

    private Object value(KeyValue<K> t) {
        if (t.getValue() == null) {
            return null;
        }
        switch (t.getType()) {
            case HASH: {
                return this.map(t);
            }
            case SET: {
                return this.set(t);
            }
            case ZSET: {
                return this.zset(t);
            }
            case STREAM: {
                return this.stream(t);
            }
            case TIMESERIES: {
                return this.timeSeries(t);
            }
        }
        return t.getValue();
    }

    private HashSet<V> set(KeyValue<K> t) {
        return new HashSet((List)t.getValue());
    }

    private List<Sample> timeSeries(KeyValue<K> t) {
        ArrayList<Sample> samples = new ArrayList<Sample>();
        for (List sample : (List)t.getValue()) {
            LettuceAssert.isTrue((sample.size() == 2 ? 1 : 0) != 0, (String)("Invalid list size: " + sample.size()));
            Long timestamp = (Long)sample.get(0);
            samples.add(Sample.of((long)timestamp, (double)this.toDouble(sample.get(1))));
        }
        return samples;
    }

    private String toString(V value) {
        return this.toStringValueFunction.apply(value);
    }

    private double toDouble(V value) {
        return Double.parseDouble(this.toString(value));
    }

    private Map<K, V> map(KeyValue<K> t) {
        List list = (List)t.getValue();
        return this.map(list);
    }

    private Map<K, V> map(List<Object> list) {
        LettuceAssert.isTrue((list.size() % 2 == 0 ? 1 : 0) != 0, (String)"List size must be a multiple of 2");
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < list.size(); i += 2) {
            map.put(list.get(i), list.get(i + 1));
        }
        return map;
    }

    private Set<ScoredValue<V>> zset(KeyValue<K> t) {
        List list = (List)t.getValue();
        LettuceAssert.isTrue((list.size() % 2 == 0 ? 1 : 0) != 0, (String)"List size must be a multiple of 2");
        HashSet<ScoredValue<V>> values = new HashSet<ScoredValue<V>>();
        for (int i = 0; i < list.size(); i += 2) {
            double score = this.toDouble(list.get(i + 1));
            values.add(ScoredValue.just((double)score, list.get(i)));
        }
        return values;
    }

    private List<StreamMessage<K, V>> stream(KeyValue<K> t) {
        ArrayList<StreamMessage<K, V>> messages = new ArrayList<StreamMessage<K, V>>();
        for (List message : (List)t.getValue()) {
            LettuceAssert.isTrue((message.size() == 2 ? 1 : 0) != 0, (String)("Invalid list size: " + message.size()));
            String id = this.toString(message.get(0));
            Map<K, V> body = this.map((List)message.get(1));
            messages.add(new StreamMessage(t.getKey(), id, body));
        }
        return messages;
    }
}

