/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.step;

import com.redis.spring.batch.reader.PollableItemReader;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.metrics.BatchMetrics;
import org.springframework.batch.core.step.item.Chunk;
import org.springframework.batch.core.step.item.SimpleChunkProvider;
import org.springframework.batch.core.step.item.SkipOverflowException;
import org.springframework.batch.core.step.skip.SkipListenerFailedException;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.util.Assert;

public class FlushingChunkProvider<I>
extends SimpleChunkProvider<I> {
    public static final Duration DEFAULT_FLUSH_INTERVAL = Duration.ofMillis(50L);
    public static final Duration DEFAULT_IDLE_TIMEOUT = Duration.ZERO;
    private final RepeatOperations repeatOperations;
    private Duration interval = DEFAULT_FLUSH_INTERVAL;
    private Duration idleTimeout = DEFAULT_IDLE_TIMEOUT;
    private long lastActivity = 0L;

    public FlushingChunkProvider(ItemReader<? extends I> itemReader, RepeatOperations repeatOperations) {
        super(itemReader, repeatOperations);
        Assert.isTrue((boolean)(itemReader instanceof PollableItemReader), (String)"Reader must extend PollableItemReader");
        this.repeatOperations = repeatOperations;
    }

    public void setInterval(Duration interval) {
        this.interval = interval;
    }

    public void setIdleTimeout(Duration timeout) {
        this.idleTimeout = timeout;
    }

    private void stopFlushTimer(Timer.Sample sample, StepExecution stepExecution, String status) {
        sample.stop(BatchMetrics.createTimer((String)"item.read", (String)"Item reading duration", (Tag[])new Tag[]{Tag.of((String)"job.name", (String)stepExecution.getJobExecution().getJobInstance().getJobName()), Tag.of((String)"step.name", (String)stepExecution.getStepName()), Tag.of((String)"status", (String)status)}));
    }

    public Chunk<I> provide(StepContribution contribution) {
        long start = System.currentTimeMillis();
        if (this.lastActivity == 0L) {
            this.lastActivity = start;
        }
        Chunk inputs = new Chunk();
        this.repeatOperations.iterate(context -> {
            I item;
            long pollingTimeout = this.interval.toMillis() - (System.currentTimeMillis() - start);
            if (pollingTimeout < 0L) {
                return RepeatStatus.FINISHED;
            }
            Timer.Sample sample = Timer.start((MeterRegistry)Metrics.globalRegistry);
            try {
                item = this.read(contribution, inputs, pollingTimeout);
            }
            catch (SkipOverflowException e) {
                this.stopFlushTimer(sample, contribution.getStepExecution(), "FAILURE");
                return RepeatStatus.FINISHED;
            }
            if (item == null) {
                if (this.isTimeout()) {
                    inputs.setEnd();
                }
                return RepeatStatus.CONTINUABLE;
            }
            this.stopFlushTimer(sample, contribution.getStepExecution(), "SUCCESS");
            inputs.add(item);
            contribution.incrementReadCount();
            this.lastActivity = System.currentTimeMillis();
            return RepeatStatus.CONTINUABLE;
        });
        return inputs;
    }

    private boolean isTimeout() {
        if (this.idleTimeout.isNegative() || this.idleTimeout.isZero()) {
            return false;
        }
        return this.millisSinceLastActivity() > this.idleTimeout.toMillis();
    }

    private long millisSinceLastActivity() {
        return System.currentTimeMillis() - this.lastActivity;
    }

    protected I read(StepContribution contribution, Chunk<I> chunk, long timeout) throws InterruptedException {
        try {
            return this.doRead(timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
    }

    protected final I doRead(long timeout) throws InterruptedException {
        try {
            this.getListener().beforeRead();
            Object item = ((PollableItemReader)this.itemReader).poll(timeout, TimeUnit.MILLISECONDS);
            if (item != null) {
                this.getListener().afterRead(item);
            }
            return (I)item;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
        catch (Exception e) {
            this.getListener().onReadError(e);
            throw e;
        }
    }

    public void postProcess(StepContribution contribution, Chunk<I> chunk) {
        for (Exception e : chunk.getErrors()) {
            try {
                this.getListener().onSkipInRead((Throwable)e);
            }
            catch (RuntimeException ex) {
                throw new SkipListenerFailedException("Fatal exception in SkipListener.", ex, (Throwable)e);
            }
        }
    }
}

