/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.step;

import com.redis.spring.batch.step.FlushingChunkProvider;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.step.item.Chunk;
import org.springframework.batch.core.step.item.SkipOverflowException;
import org.springframework.batch.core.step.skip.LimitCheckingItemSkipPolicy;
import org.springframework.batch.core.step.skip.NonSkippableReadException;
import org.springframework.batch.core.step.skip.SkipException;
import org.springframework.batch.core.step.skip.SkipListenerFailedException;
import org.springframework.batch.core.step.skip.SkipPolicy;
import org.springframework.batch.core.step.skip.SkipPolicyFailedException;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.classify.BinaryExceptionClassifier;
import org.springframework.classify.Classifier;

public class FlushingFaultTolerantChunkProvider<I>
extends FlushingChunkProvider<I> {
    public static final int DEFAULT_MAX_SKIPS_ON_READ = 100;
    private SkipPolicy skipPolicy = new LimitCheckingItemSkipPolicy();
    private Classifier<Throwable, Boolean> rollbackClassifier = new BinaryExceptionClassifier(true);
    private int maxSkipsOnRead = 100;

    public FlushingFaultTolerantChunkProvider(ItemReader<? extends I> itemReader, RepeatOperations repeatOperations) {
        super(itemReader, repeatOperations);
    }

    public void setMaxSkipsOnRead(int maxSkipsOnRead) {
        this.maxSkipsOnRead = maxSkipsOnRead;
    }

    public void setSkipPolicy(SkipPolicy skipPolicy) {
        this.skipPolicy = skipPolicy;
    }

    public void setRollbackClassifier(Classifier<Throwable, Boolean> rollbackClassifier) {
        this.rollbackClassifier = rollbackClassifier;
    }

    @Override
    protected I read(StepContribution contribution, Chunk<I> chunk, long timeout) throws InterruptedException {
        while (true) {
            try {
                return this.doRead(timeout);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw e;
            }
            catch (Exception e) {
                this.handleException(e, contribution, chunk);
                continue;
            }
            break;
        }
    }

    private void handleException(Exception e, StepContribution contribution, Chunk<I> chunk) {
        if (this.shouldSkip(this.skipPolicy, e, contribution.getStepSkipCount())) {
            contribution.incrementReadSkipCount();
            chunk.skip(e);
            if (chunk.getErrors().size() >= this.maxSkipsOnRead) {
                throw new SkipOverflowException("Too many skips on read");
            }
            this.logger.debug((Object)"Skipping failed input", (Throwable)e);
        } else {
            if (Boolean.TRUE.equals(this.rollbackClassifier.classify((Object)e))) {
                throw new NonSkippableReadException("Non-skippable exception during read", (Throwable)e);
            }
            this.logger.debug((Object)"No-rollback for non-skippable exception (ignored)", (Throwable)e);
        }
    }

    private boolean shouldSkip(SkipPolicy policy, Throwable e, int skipCount) {
        try {
            return policy.shouldSkip(e, skipCount);
        }
        catch (SkipException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new SkipPolicyFailedException("Fatal exception in SkipPolicy.", ex, e);
        }
    }

    @Override
    public void postProcess(StepContribution contribution, Chunk<I> chunk) {
        for (Exception e : chunk.getErrors()) {
            try {
                this.getListener().onSkipInRead((Throwable)e);
            }
            catch (RuntimeException ex) {
                throw new SkipListenerFailedException("Fatal exception in SkipListener.", ex, (Throwable)e);
            }
        }
    }
}

