/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.step;

import com.redis.spring.batch.reader.PollableItemReader;
import com.redis.spring.batch.step.FlushingChunkProvider;
import com.redis.spring.batch.step.FlushingFaultTolerantChunkProvider;
import com.redis.spring.batch.step.FlushingStepBuilder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.function.Function;
import org.springframework.batch.core.ItemProcessListener;
import org.springframework.batch.core.ItemReadListener;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.step.builder.FaultTolerantStepBuilder;
import org.springframework.batch.core.step.builder.SimpleStepBuilder;
import org.springframework.batch.core.step.builder.StepBuilderHelper;
import org.springframework.batch.core.step.item.ChunkProvider;
import org.springframework.batch.core.step.skip.SkipPolicy;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.classify.Classifier;
import org.springframework.util.Assert;

public class FlushingFaultTolerantStepBuilder<I, O>
extends FaultTolerantStepBuilder<I, O> {
    private Duration interval = FlushingChunkProvider.DEFAULT_FLUSH_INTERVAL;
    private Duration idleTimeout;

    public FlushingFaultTolerantStepBuilder(StepBuilderHelper<?> parent) {
        super(parent);
    }

    public FlushingFaultTolerantStepBuilder(SimpleStepBuilder<I, O> parent) {
        super(parent);
    }

    public FlushingFaultTolerantStepBuilder(FlushingStepBuilder<I, O> parent) {
        super(parent);
        this.interval = parent.getInterval();
        this.idleTimeout = parent.getIdleTimeout();
    }

    protected ChunkProvider<I> createChunkProvider() {
        SkipPolicy readSkipPolicy = this.createSkipPolicy();
        readSkipPolicy = this.getFatalExceptionAwareProxy(readSkipPolicy);
        int maxSkipsOnRead = Math.max(this.getChunkSize(), 100);
        FlushingFaultTolerantChunkProvider chunkProvider = new FlushingFaultTolerantChunkProvider(this.getReader(), this.createChunkOperations());
        chunkProvider.setMaxSkipsOnRead(maxSkipsOnRead);
        chunkProvider.setSkipPolicy(readSkipPolicy);
        chunkProvider.setRollbackClassifier((Classifier<Throwable, Boolean>)this.getRollbackClassifier());
        chunkProvider.setInterval(this.interval);
        chunkProvider.setIdleTimeout(this.idleTimeout);
        ArrayList listeners = new ArrayList(this.getItemListeners());
        listeners.addAll(this.getSkipListeners());
        chunkProvider.setListeners(listeners);
        return chunkProvider;
    }

    public FlushingFaultTolerantStepBuilder<I, O> chunk(int chunkSize) {
        return (FlushingFaultTolerantStepBuilder)super.chunk(chunkSize);
    }

    public FlushingFaultTolerantStepBuilder<I, O> chunk(CompletionPolicy completionPolicy) {
        return (FlushingFaultTolerantStepBuilder)super.chunk(completionPolicy);
    }

    public FlushingFaultTolerantStepBuilder<I, O> interval(Duration interval) {
        this.interval = interval;
        return this;
    }

    public FlushingFaultTolerantStepBuilder<I, O> idleTimeout(Duration timeout) {
        this.idleTimeout = timeout;
        return this;
    }

    public FlushingFaultTolerantStepBuilder<I, O> faultTolerant() {
        return (FlushingFaultTolerantStepBuilder)super.faultTolerant();
    }

    public FlushingFaultTolerantStepBuilder<I, O> reader(ItemReader<? extends I> reader) {
        Assert.state((boolean)(reader instanceof PollableItemReader), (String)"Reader must be an instance of PollableItemReader");
        return (FlushingFaultTolerantStepBuilder)super.reader(reader);
    }

    public FlushingFaultTolerantStepBuilder<I, O> writer(ItemWriter<? super O> writer) {
        return (FlushingFaultTolerantStepBuilder)super.writer(writer);
    }

    public FlushingFaultTolerantStepBuilder<I, O> processor(Function<? super I, ? extends O> function) {
        return (FlushingFaultTolerantStepBuilder)super.processor(function);
    }

    public FlushingFaultTolerantStepBuilder<I, O> processor(ItemProcessor<? super I, ? extends O> processor) {
        return (FlushingFaultTolerantStepBuilder)super.processor(processor);
    }

    public FlushingFaultTolerantStepBuilder<I, O> readerIsTransactionalQueue() {
        return (FlushingFaultTolerantStepBuilder)super.readerIsTransactionalQueue();
    }

    public FlushingFaultTolerantStepBuilder<I, O> listener(Object listener) {
        return (FlushingFaultTolerantStepBuilder)super.listener(listener);
    }

    public FlushingFaultTolerantStepBuilder<I, O> listener(ItemReadListener<? super I> listener) {
        return (FlushingFaultTolerantStepBuilder)super.listener(listener);
    }

    public FlushingFaultTolerantStepBuilder<I, O> listener(ItemWriteListener<? super O> listener) {
        return (FlushingFaultTolerantStepBuilder)super.listener(listener);
    }

    public FlushingFaultTolerantStepBuilder<I, O> listener(ItemProcessListener<? super I, ? super O> listener) {
        return (FlushingFaultTolerantStepBuilder)super.listener(listener);
    }

    public FlushingFaultTolerantStepBuilder<I, O> chunkOperations(RepeatOperations repeatTemplate) {
        return (FlushingFaultTolerantStepBuilder)super.chunkOperations(repeatTemplate);
    }
}

