/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.step;

import com.redis.spring.batch.reader.PollableItemReader;
import com.redis.spring.batch.step.FlushingChunkProvider;
import com.redis.spring.batch.step.FlushingFaultTolerantStepBuilder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.function.Function;
import org.springframework.batch.core.ItemProcessListener;
import org.springframework.batch.core.ItemReadListener;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.step.builder.SimpleStepBuilder;
import org.springframework.batch.core.step.builder.StepBuilderHelper;
import org.springframework.batch.core.step.item.ChunkOrientedTasklet;
import org.springframework.batch.core.step.item.SimpleChunkProcessor;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.util.Assert;

public class FlushingStepBuilder<I, O>
extends SimpleStepBuilder<I, O> {
    private Duration interval = FlushingChunkProvider.DEFAULT_FLUSH_INTERVAL;
    private Duration idleTimeout;

    public FlushingStepBuilder(StepBuilderHelper<?> parent) {
        super(parent);
    }

    public FlushingStepBuilder(SimpleStepBuilder<I, O> parent) {
        super(parent);
    }

    public FlushingFaultTolerantStepBuilder<I, O> faultTolerant() {
        return new FlushingFaultTolerantStepBuilder(this);
    }

    protected Tasklet createTasklet() {
        ItemReader reader = this.getReader();
        ItemWriter writer = this.getWriter();
        Assert.state((reader != null ? 1 : 0) != 0, (String)"ItemReader must be provided");
        Assert.state((writer != null ? 1 : 0) != 0, (String)"ItemWriter must be provided");
        FlushingChunkProvider<I> chunkProvider = this.createChunkProvider();
        SimpleChunkProcessor<I, O> chunkProcessor = this.createChunkProcessor();
        ChunkOrientedTasklet tasklet = new ChunkOrientedTasklet(chunkProvider, chunkProcessor);
        tasklet.setBuffering(!this.isReaderTransactionalQueue());
        return tasklet;
    }

    private SimpleChunkProcessor<I, O> createChunkProcessor() {
        SimpleChunkProcessor chunkProcessor = new SimpleChunkProcessor(this.getProcessor(), this.getWriter());
        chunkProcessor.setListeners(new ArrayList(this.getItemListeners()));
        return chunkProcessor;
    }

    protected FlushingChunkProvider<I> createChunkProvider() {
        FlushingChunkProvider chunkProvider = new FlushingChunkProvider(this.getReader(), this.createChunkOperations());
        chunkProvider.setInterval(this.interval);
        chunkProvider.setIdleTimeout(this.idleTimeout);
        ArrayList listeners = new ArrayList(this.getItemListeners());
        chunkProvider.setListeners(listeners);
        return chunkProvider;
    }

    public FlushingStepBuilder<I, O> chunk(int chunkSize) {
        return (FlushingStepBuilder)super.chunk(chunkSize);
    }

    public FlushingStepBuilder<I, O> chunk(CompletionPolicy completionPolicy) {
        return (FlushingStepBuilder)super.chunk(completionPolicy);
    }

    public FlushingStepBuilder<I, O> idleTimeout(Duration timeout) {
        this.idleTimeout = timeout;
        return this;
    }

    public FlushingStepBuilder<I, O> interval(Duration interval) {
        this.interval = interval;
        return this;
    }

    public FlushingStepBuilder<I, O> reader(ItemReader<? extends I> reader) {
        Assert.state((boolean)(reader instanceof PollableItemReader), (String)"Reader must be an instance of PollableItemReader");
        return (FlushingStepBuilder)super.reader(reader);
    }

    public FlushingStepBuilder<I, O> writer(ItemWriter<? super O> writer) {
        return (FlushingStepBuilder)super.writer(writer);
    }

    public FlushingStepBuilder<I, O> processor(Function<? super I, ? extends O> function) {
        return (FlushingStepBuilder)super.processor(function);
    }

    public FlushingStepBuilder<I, O> processor(ItemProcessor<? super I, ? extends O> processor) {
        return (FlushingStepBuilder)super.processor(processor);
    }

    public FlushingStepBuilder<I, O> readerIsTransactionalQueue() {
        return (FlushingStepBuilder)super.readerIsTransactionalQueue();
    }

    public FlushingStepBuilder<I, O> listener(Object listener) {
        return (FlushingStepBuilder)super.listener(listener);
    }

    public FlushingStepBuilder<I, O> listener(ItemReadListener<? super I> listener) {
        return (FlushingStepBuilder)super.listener(listener);
    }

    public FlushingStepBuilder<I, O> listener(ItemWriteListener<? super O> listener) {
        return (FlushingStepBuilder)super.listener(listener);
    }

    public FlushingStepBuilder<I, O> listener(ItemProcessListener<? super I, ? super O> listener) {
        return (FlushingStepBuilder)super.listener(listener);
    }

    public FlushingStepBuilder<I, O> chunkOperations(RepeatOperations repeatTemplate) {
        return (FlushingStepBuilder)super.chunkOperations(repeatTemplate);
    }

    public Duration getInterval() {
        return this.interval;
    }

    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }
}

