/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.util;

import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import java.nio.ByteBuffer;
import java.util.function.Function;

public abstract class CodecUtils {
    public static final StringCodec STRING_CODEC = StringCodec.UTF8;
    public static final ByteArrayCodec BYTE_ARRAY_CODEC = ByteArrayCodec.INSTANCE;

    private CodecUtils() {
    }

    public static <K> Function<String, K> stringKeyFunction(RedisCodec<K, ?> codec) {
        Function<String, ByteBuffer> encode = arg_0 -> ((StringCodec)STRING_CODEC).encodeKey(arg_0);
        return encode.andThen(arg_0 -> codec.decodeKey(arg_0));
    }

    public static <K> Function<K, String> toStringKeyFunction(RedisCodec<K, ?> codec) {
        Function<Object, ByteBuffer> encode = arg_0 -> codec.encodeKey(arg_0);
        return encode.andThen(arg_0 -> ((StringCodec)STRING_CODEC).decodeKey(arg_0));
    }

    public static <V> Function<String, V> stringValueFunction(RedisCodec<?, V> codec) {
        Function<String, ByteBuffer> encode = arg_0 -> ((StringCodec)STRING_CODEC).encodeValue(arg_0);
        return encode.andThen(arg_0 -> codec.decodeValue(arg_0));
    }

    public static <V> Function<V, String> toStringValueFunction(RedisCodec<?, V> codec) {
        Function<Object, ByteBuffer> encode = arg_0 -> codec.encodeValue(arg_0);
        return encode.andThen(arg_0 -> ((StringCodec)STRING_CODEC).decodeValue(arg_0));
    }

    public static <K> Function<byte[], K> byteArrayKeyFunction(RedisCodec<K, ?> codec) {
        Function<byte[], ByteBuffer> encode = arg_0 -> ((ByteArrayCodec)BYTE_ARRAY_CODEC).encodeKey(arg_0);
        return encode.andThen(arg_0 -> codec.decodeKey(arg_0));
    }

    public static <K> Function<K, byte[]> toByteArrayKeyFunction(RedisCodec<K, ?> codec) {
        Function<Object, ByteBuffer> encode = arg_0 -> codec.encodeKey(arg_0);
        return encode.andThen(arg_0 -> ((ByteArrayCodec)BYTE_ARRAY_CODEC).decodeKey(arg_0));
    }

    public static <V> Function<byte[], V> byteArrayValueFunction(RedisCodec<?, V> codec) {
        Function<byte[], ByteBuffer> encode = arg_0 -> ((ByteArrayCodec)BYTE_ARRAY_CODEC).encodeValue(arg_0);
        return encode.andThen(arg_0 -> codec.decodeValue(arg_0));
    }

    public static <V> Function<V, byte[]> toByteArrayValueFunction(RedisCodec<?, V> codec) {
        Function<Object, ByteBuffer> encode = arg_0 -> codec.encodeValue(arg_0);
        return encode.andThen(arg_0 -> ((ByteArrayCodec)BYTE_ARRAY_CODEC).decodeValue(arg_0));
    }
}

