/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.util;

import com.redis.lettucemod.RedisModulesClient;
import com.redis.lettucemod.api.StatefulRedisModulesConnection;
import com.redis.lettucemod.cluster.RedisModulesClusterClient;
import com.redis.lettucemod.cluster.api.StatefulRedisModulesClusterConnection;
import com.redis.spring.batch.util.CodecUtils;
import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisScriptingCommands;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.codec.RedisCodec;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.util.FileCopyUtils;

public abstract class ConnectionUtils {
    private ConnectionUtils() {
    }

    public static Supplier<StatefulConnection<String, String>> supplier(AbstractRedisClient client) {
        return ConnectionUtils.supplier(client, CodecUtils.STRING_CODEC);
    }

    public static Supplier<StatefulConnection<String, String>> supplier(AbstractRedisClient client, ReadFrom readFrom) {
        return ConnectionUtils.supplier(client, CodecUtils.STRING_CODEC, readFrom);
    }

    public static <K, V> Supplier<StatefulConnection<K, V>> supplier(AbstractRedisClient client, RedisCodec<K, V> codec) {
        return ConnectionUtils.supplier(client, codec, null);
    }

    public static <K, V> Supplier<StatefulConnection<K, V>> supplier(AbstractRedisClient client, RedisCodec<K, V> codec, ReadFrom readFrom) {
        if (client instanceof RedisModulesClusterClient) {
            return () -> ConnectionUtils.connection((RedisModulesClusterClient)client, codec, readFrom);
        }
        return () -> ConnectionUtils.connection((RedisModulesClient)client, codec);
    }

    public static <K, V> StatefulRedisModulesConnection<K, V> connection(AbstractRedisClient client, RedisCodec<K, V> codec, ReadFrom readFrom) {
        if (client instanceof RedisModulesClusterClient) {
            return ConnectionUtils.connection((RedisModulesClusterClient)client, codec, readFrom);
        }
        return ConnectionUtils.connection((RedisModulesClient)client, codec);
    }

    public static <K, V> StatefulRedisModulesConnection<K, V> connection(RedisModulesClient client, RedisCodec<K, V> codec) {
        return client.connect(codec);
    }

    public static <K, V> StatefulRedisModulesConnection<K, V> connection(RedisModulesClusterClient client, RedisCodec<K, V> codec, ReadFrom readFrom) {
        StatefulRedisModulesClusterConnection connection = client.connect(codec);
        if (readFrom != null) {
            connection.setReadFrom(readFrom);
        }
        return connection;
    }

    public static <K, V, T> T sync(StatefulConnection<K, V> connection) {
        if (connection instanceof StatefulRedisClusterConnection) {
            return (T)((StatefulRedisClusterConnection)connection).sync();
        }
        return (T)((StatefulRedisConnection)connection).sync();
    }

    public static <K, V, T> T async(StatefulConnection<K, V> connection) {
        if (connection instanceof StatefulRedisClusterConnection) {
            return (T)((StatefulRedisClusterConnection)connection).async();
        }
        return (T)((StatefulRedisConnection)connection).async();
    }

    public static String loadScript(AbstractRedisClient client, String filename) {
        byte[] bytes;
        try (InputStream inputStream = ConnectionUtils.class.getClassLoader().getResourceAsStream(filename);){
            bytes = FileCopyUtils.copyToByteArray((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new ItemStreamException("Could not read LUA script file " + filename);
        }
        try (StatefulConnection connection = ConnectionUtils.supplier(client, CodecUtils.STRING_CODEC).get();){
            String string = ((RedisScriptingCommands)ConnectionUtils.sync(connection)).scriptLoad(bytes);
            return string;
        }
    }
}

