/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.util;

import com.hrakaroo.glob.GlobPattern;
import com.hrakaroo.glob.MatchingEngine;
import com.redis.spring.batch.common.Range;
import com.redis.spring.batch.util.CodecUtils;
import io.lettuce.core.cluster.SlotHash;
import io.lettuce.core.codec.RedisCodec;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public interface Predicates {
    public static <T> Predicate<T> and(Predicate<T> ... predicates) {
        return Predicates.and(Arrays.asList(predicates));
    }

    public static <T> Predicate<T> and(Collection<Predicate<T>> predicates) {
        if (CollectionUtils.isEmpty(predicates)) {
            return Predicates.isTrue();
        }
        if (predicates.size() == 1) {
            return predicates.iterator().next();
        }
        return Predicates.and(predicates.stream());
    }

    public static <T> Predicate<T> and(Stream<Predicate<T>> predicates) {
        return predicates.reduce(Predicates.isTrue(), Predicate::and);
    }

    public static <T> Predicate<T> or(Predicate<T> ... predicates) {
        return Predicates.or(Arrays.asList(predicates));
    }

    public static <T> Predicate<T> or(Collection<Predicate<T>> predicates) {
        if (CollectionUtils.isEmpty(predicates)) {
            return Predicates.isTrue();
        }
        if (predicates.size() == 1) {
            return predicates.iterator().next();
        }
        return Predicates.or(predicates.stream());
    }

    public static <T> Predicate<T> or(Stream<Predicate<T>> predicates) {
        return predicates.reduce(Predicates.isFalse(), Predicate::or);
    }

    public static IntPredicate intAnd(IntPredicate ... predicates) {
        return Predicates.intAnd(Arrays.asList(predicates));
    }

    public static IntPredicate intAnd(Collection<IntPredicate> predicates) {
        if (CollectionUtils.isEmpty(predicates)) {
            return Predicates.intIsTrue();
        }
        return Predicates.intAnd(predicates.stream());
    }

    public static IntPredicate intAnd(Stream<IntPredicate> predicates) {
        return predicates.reduce(Predicates.intIsTrue(), IntPredicate::and);
    }

    public static IntPredicate intOr(IntPredicate ... predicates) {
        return Predicates.intOr(Arrays.asList(predicates));
    }

    public static IntPredicate intOr(Collection<IntPredicate> predicates) {
        if (CollectionUtils.isEmpty(predicates)) {
            return Predicates.intIsTrue();
        }
        return Predicates.intOr(predicates.stream());
    }

    public static IntPredicate intOr(Stream<IntPredicate> predicates) {
        return predicates.reduce(Predicates.intIsFalse(), IntPredicate::or);
    }

    public static <T> Predicate<T> intMap(ToIntFunction<T> function, IntPredicate predicate) {
        return k -> predicate.test(function.applyAsInt(k));
    }

    public static <S, T> Predicate<S> map(Function<S, T> function, Predicate<T> predicate) {
        return s -> predicate.test(function.apply(s));
    }

    public static Predicate<String> slots(Collection<Range> ranges) {
        return Predicates.slots(CodecUtils.STRING_CODEC, ranges);
    }

    public static <K> Predicate<K> slots(RedisCodec<K, ?> codec, Collection<Range> ranges) {
        if (CollectionUtils.isEmpty(ranges)) {
            return Predicates.isTrue();
        }
        return Predicates.slots(codec, ranges.stream());
    }

    public static <K> Predicate<K> slots(RedisCodec<K, ?> codec, Range ... ranges) {
        return Predicates.slots(codec, Arrays.asList(ranges));
    }

    public static Predicate<String> slots(Range ... ranges) {
        return Predicates.slots(CodecUtils.STRING_CODEC, ranges);
    }

    public static <K> Predicate<K> slots(RedisCodec<K, ?> codec, Stream<Range> ranges) {
        ToIntFunction<Object> slot = k -> SlotHash.getSlot((ByteBuffer)codec.encodeKey(k));
        IntPredicate predicate = Predicates.intAnd((IntPredicate[])ranges.map(Range::asPredicate).toArray(IntPredicate[]::new));
        return Predicates.intMap(slot, predicate);
    }

    public static Predicate<String> regex(String regex) {
        return Pattern.compile(regex).asPredicate();
    }

    public static <T> Predicate<T> isTrue() {
        return Predicates.is(true);
    }

    public static IntPredicate intIsTrue() {
        return Predicates.intIs(true);
    }

    public static <T> Predicate<T> isFalse() {
        return Predicates.is(false);
    }

    public static IntPredicate intIsFalse() {
        return Predicates.intIs(false);
    }

    public static <T> Predicate<T> negate(Predicate<T> predicate) {
        Assert.notNull(predicate, (String)"Predicate must not be null");
        return predicate.negate();
    }

    public static IntPredicate intNegate(IntPredicate predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        return predicate.negate();
    }

    public static Predicate<String> glob(String match) {
        if (!StringUtils.hasLength((String)match)) {
            return Predicates.isTrue();
        }
        return arg_0 -> ((MatchingEngine)GlobPattern.compile((String)match)).matches(arg_0);
    }

    public static <T> Predicate<T> is(boolean value) {
        return t -> value;
    }

    public static IntPredicate intIs(boolean value) {
        return t -> value;
    }
}

