/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer;

import com.redis.spring.batch.common.AbstractOperationExecutor;
import com.redis.spring.batch.writer.BatchWriteOperation;
import com.redis.spring.batch.writer.operation.MultiExecBatchWriteOperation;
import com.redis.spring.batch.writer.operation.ReplicaWaitBatchWriteOperation;
import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.RedisException;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.codec.RedisCodec;
import java.time.Duration;
import java.util.List;
import org.springframework.batch.item.ItemStreamWriter;

public abstract class AbstractOperationItemWriter<K, V, T>
extends AbstractOperationExecutor<K, V, T, Object>
implements ItemStreamWriter<T> {
    public static final Duration DEFAULT_WAIT_TIMEOUT = Duration.ofSeconds(1L);
    private int waitReplicas;
    private Duration waitTimeout = DEFAULT_WAIT_TIMEOUT;
    private boolean multiExec;

    protected AbstractOperationItemWriter(AbstractRedisClient client, RedisCodec<K, V> codec) {
        super(client, codec);
    }

    public void setWaitReplicas(int replicas) {
        this.waitReplicas = replicas;
    }

    public void setWaitTimeout(Duration timeout) {
        this.waitTimeout = timeout;
    }

    public void setMultiExec(boolean multiExec) {
        this.multiExec = multiExec;
    }

    public void write(List<? extends T> items) throws RedisException {
        this.process(items);
    }

    protected BatchWriteOperation<K, V, T> batchOperation() {
        BatchWriteOperation<K, V, T> batchOperation = this.batchWriteOperation();
        batchOperation = this.replicaWaitOperation(batchOperation);
        return this.multiExec(batchOperation);
    }

    protected abstract BatchWriteOperation<K, V, T> batchWriteOperation();

    private BatchWriteOperation<K, V, T> multiExec(BatchWriteOperation<K, V, T> operation) {
        if (this.multiExec) {
            if (this.client instanceof RedisClusterClient) {
                throw new UnsupportedOperationException("Multi/exec is not supported on Redis Cluster");
            }
            return new MultiExecBatchWriteOperation<K, V, T>(operation);
        }
        return operation;
    }

    private BatchWriteOperation<K, V, T> replicaWaitOperation(BatchWriteOperation<K, V, T> operation) {
        if (this.waitReplicas > 0) {
            return new ReplicaWaitBatchWriteOperation<K, V, T>(operation, this.waitReplicas, this.waitTimeout);
        }
        return operation;
    }
}

