/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamSupport;
import org.springframework.batch.item.support.AbstractItemStreamItemWriter;
import org.springframework.util.ClassUtils;

public class ProcessingItemWriter<K, T>
extends AbstractItemStreamItemWriter<K> {
    private final ItemProcessor<List<K>, List<T>> processor;
    private final BlockingQueue<T> queue;
    private boolean open;

    public ProcessingItemWriter(ItemProcessor<List<K>, List<T>> processor, BlockingQueue<T> queue) {
        this.processor = processor;
        this.queue = queue;
        this.setName(ClassUtils.getShortName(((Object)((Object)this)).getClass()));
    }

    public void setName(String name) {
        super.setName(name);
        if (this.processor instanceof ItemStreamSupport) {
            ((ItemStreamSupport)this.processor).setName(name + "-processor");
        }
    }

    public void open(ExecutionContext executionContext) {
        if (this.processor instanceof ItemStream) {
            ((ItemStream)this.processor).open(executionContext);
        }
        super.open(executionContext);
        this.open = true;
    }

    public void update(ExecutionContext executionContext) {
        if (this.processor instanceof ItemStream) {
            ((ItemStream)this.processor).update(executionContext);
        }
        super.update(executionContext);
    }

    public void close() {
        if (this.processor instanceof ItemStream) {
            ((ItemStream)this.processor).close();
        }
        super.close();
        this.open = false;
    }

    public void write(List<? extends K> items) throws Exception {
        List values = (List)this.processor.process(items);
        if (values != null) {
            for (Object item : values) {
                this.queue.put(item);
            }
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public BlockingQueue<T> getQueue() {
        return this.queue;
    }
}

