/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.spring.batch.writer.WriteOperation;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import java.util.function.Function;

public abstract class AbstractKeyWriteOperation<K, V, I>
implements WriteOperation<K, V, I> {
    private Function<I, K> keyFunction;

    public void setKeyFunction(Function<I, K> function) {
        this.keyFunction = function;
    }

    public void setKey(K key) {
        this.keyFunction = t -> key;
    }

    @Override
    public RedisFuture<Object> execute(BaseRedisAsyncCommands<K, V> commands, I item) {
        K key = this.keyFunction.apply(item);
        if (key == null) {
            return null;
        }
        return this.execute(commands, item, key);
    }

    protected abstract RedisFuture<?> execute(BaseRedisAsyncCommands<K, V> var1, I var2, K var3);
}

