/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.spring.batch.common.KeyValue;
import com.redis.spring.batch.writer.WriteOperation;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.RestoreArgs;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import io.lettuce.core.api.async.RedisKeyAsyncCommands;

public class DumpWriteOperation<K, V>
implements WriteOperation<K, V, KeyValue<K>> {
    @Override
    public RedisFuture<Object> execute(BaseRedisAsyncCommands<K, V> commands, KeyValue<K> item) {
        RedisKeyAsyncCommands keyCommands = (RedisKeyAsyncCommands)commands;
        if (item.getValue() == null || item.getTtl() == -2L) {
            return keyCommands.del(new Object[]{item.getKey()});
        }
        RestoreArgs args = new RestoreArgs().replace(true);
        if (item.getTtl() > 0L) {
            args.absttl().ttl(item.getTtl());
        }
        return keyCommands.restore(item.getKey(), (byte[])item.getValue(), args);
    }
}

