/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.spring.batch.writer.operation.AbstractKeyWriteOperation;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import io.lettuce.core.api.async.RedisKeyAsyncCommands;
import java.time.Duration;
import java.util.function.Function;

public class Expire<K, V, T>
extends AbstractKeyWriteOperation<K, V, T> {
    private Function<T, Duration> ttlFunction = t -> Duration.ZERO;

    public void setTtl(Duration duration) {
        this.ttlFunction = t -> duration;
    }

    public void setTtlFunction(Function<T, Duration> function) {
        this.ttlFunction = function;
    }

    @Override
    protected RedisFuture<Boolean> execute(BaseRedisAsyncCommands<K, V> commands, T item, K key) {
        Duration duration = this.ttlFunction.apply(item);
        if (duration == null || duration.isNegative() || duration.isZero()) {
            return null;
        }
        return ((RedisKeyAsyncCommands)commands).pexpire(key, duration);
    }
}

