/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.spring.batch.writer.operation.AbstractKeyWriteOperation;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import io.lettuce.core.api.async.RedisKeyAsyncCommands;
import java.util.function.ToLongFunction;

public class ExpireAt<K, V, T>
extends AbstractKeyWriteOperation<K, V, T> {
    private ToLongFunction<T> epochFunction;

    public void setEpoch(long epoch) {
        this.epochFunction = t -> epoch;
    }

    public void setEpochFunction(ToLongFunction<T> function) {
        this.epochFunction = function;
    }

    @Override
    protected RedisFuture<Boolean> execute(BaseRedisAsyncCommands<K, V> commands, T item, K key) {
        long millis = this.epochFunction.applyAsLong(item);
        if (millis > 0L) {
            return ((RedisKeyAsyncCommands)commands).pexpireat(key, millis);
        }
        return null;
    }
}

