/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.spring.batch.writer.operation.AbstractKeyWriteOperation;
import io.lettuce.core.GeoAddArgs;
import io.lettuce.core.GeoValue;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import io.lettuce.core.api.async.RedisGeoAsyncCommands;
import java.util.function.Function;

public class Geoadd<K, V, T>
extends AbstractKeyWriteOperation<K, V, T> {
    private Function<T, GeoValue<V>> valueFunction;
    private Function<T, GeoAddArgs> argsFunction = t -> null;

    public void setValueFunction(Function<T, GeoValue<V>> value) {
        this.valueFunction = value;
    }

    public void setArgs(GeoAddArgs args) {
        this.argsFunction = t -> args;
    }

    public void setArgsFunction(Function<T, GeoAddArgs> args) {
        this.argsFunction = args;
    }

    @Override
    protected RedisFuture<Long> execute(BaseRedisAsyncCommands<K, V> commands, T item, K key) {
        GeoAddArgs args = this.argsFunction.apply(item);
        GeoValue<V> value = this.valueFunction.apply(item);
        return ((RedisGeoAsyncCommands)commands).geoadd(key, args, new GeoValue[]{value});
    }
}

