/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.spring.batch.writer.operation.AbstractKeyWriteOperation;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import io.lettuce.core.api.async.RedisHashAsyncCommands;
import java.util.Map;
import java.util.function.Function;
import org.springframework.util.CollectionUtils;

public class Hset<K, V, T>
extends AbstractKeyWriteOperation<K, V, T> {
    private Function<T, Map<K, V>> mapFunction;

    public void setMapFunction(Function<T, Map<K, V>> map) {
        this.mapFunction = map;
    }

    @Override
    protected RedisFuture<Long> execute(BaseRedisAsyncCommands<K, V> commands, T item, K key) {
        Map<K, V> map = this.mapFunction.apply(item);
        if (CollectionUtils.isEmpty(map)) {
            return null;
        }
        return ((RedisHashAsyncCommands)commands).hset(key, map);
    }
}

