/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.lettucemod.api.async.RedisJSONAsyncCommands;
import com.redis.spring.batch.writer.operation.AbstractKeyWriteOperation;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import java.util.function.Function;

public class JsonSet<K, V, T>
extends AbstractKeyWriteOperation<K, V, T> {
    public static final String ROOT_PATH = "$";
    private Function<T, String> pathFunction = t -> "$";
    private Function<T, V> valueFunction;

    public void setPath(String path) {
        this.pathFunction = t -> path;
    }

    public void setPathFunction(Function<T, String> path) {
        this.pathFunction = path;
    }

    public void setValueFunction(Function<T, V> value) {
        this.valueFunction = value;
    }

    @Override
    protected RedisFuture<String> execute(BaseRedisAsyncCommands<K, V> commands, T item, K key) {
        String path = this.pathFunction.apply(item);
        V value = this.valueFunction.apply(item);
        return ((RedisJSONAsyncCommands)commands).jsonSet(key, path, value);
    }
}

