/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.spring.batch.writer.BatchWriteOperation;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import io.lettuce.core.api.async.RedisTransactionalAsyncCommands;
import java.util.ArrayList;
import java.util.List;

public class MultiExecBatchWriteOperation<K, V, T>
implements BatchWriteOperation<K, V, T> {
    private final BatchWriteOperation<K, V, T> delegate;

    public MultiExecBatchWriteOperation(BatchWriteOperation<K, V, T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public List<RedisFuture<Object>> execute(BaseRedisAsyncCommands<K, V> commands, List<T> items) {
        ArrayList<RedisFuture<Object>> futures = new ArrayList<RedisFuture<Object>>();
        RedisTransactionalAsyncCommands transactionalCommands = (RedisTransactionalAsyncCommands)commands;
        futures.add(transactionalCommands.multi());
        futures.addAll(this.delegate.execute(commands, items));
        futures.add(transactionalCommands.exec());
        return futures;
    }
}

