/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.spring.batch.writer.BatchWriteOperation;
import io.lettuce.core.RedisCommandExecutionException;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import io.lettuce.core.cluster.PipelinedRedisFuture;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public class ReplicaWaitBatchWriteOperation<K, V, I>
implements BatchWriteOperation<K, V, I> {
    private final BatchWriteOperation<K, V, I> delegate;
    private final int replicas;
    private final long timeout;

    public ReplicaWaitBatchWriteOperation(BatchWriteOperation<K, V, I> delegate, int replicas, Duration timeout) {
        this.delegate = delegate;
        this.replicas = replicas;
        this.timeout = timeout.toMillis();
    }

    @Override
    public List<RedisFuture<Object>> execute(BaseRedisAsyncCommands<K, V> commands, List<I> items) {
        ArrayList<RedisFuture<Object>> futures = new ArrayList<RedisFuture<Object>>();
        futures.addAll(this.delegate.execute(commands, items));
        RedisFuture waitFuture = commands.waitForReplication(this.replicas, this.timeout);
        futures.add((RedisFuture<Object>)new PipelinedRedisFuture(waitFuture.thenAccept(this::checkReplicas)));
        return futures;
    }

    private void checkReplicas(Long actual) {
        if (actual == null || actual < (long)this.replicas) {
            throw new RedisCommandExecutionException(this.errorMessage(actual));
        }
    }

    private String errorMessage(Long actual) {
        return MessageFormat.format("Insufficient replication level ({0}/{1})", actual, this.replicas);
    }
}

