/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.spring.batch.writer.operation.AbstractKeyWriteOperation;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.SetArgs;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import io.lettuce.core.api.async.RedisStringAsyncCommands;
import java.util.function.Function;

public class Set<K, V, T>
extends AbstractKeyWriteOperation<K, V, T> {
    private static final SetArgs DEFAULT_ARGS = new SetArgs();
    private Function<T, V> valueFunction;
    private Function<T, SetArgs> argsFunction = t -> DEFAULT_ARGS;

    public void setValueFunction(Function<T, V> function) {
        this.valueFunction = function;
    }

    public void setArgs(SetArgs args) {
        this.argsFunction = t -> args;
    }

    public void setArgsFunction(Function<T, SetArgs> function) {
        this.argsFunction = function;
    }

    @Override
    protected RedisFuture<String> execute(BaseRedisAsyncCommands<K, V> commands, T item, K key) {
        V value = this.valueFunction.apply(item);
        SetArgs args = this.argsFunction.apply(item);
        return ((RedisStringAsyncCommands)commands).set(key, value, args);
    }
}

