/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.lettucemod.timeseries.AddOptions;
import com.redis.lettucemod.timeseries.DuplicatePolicy;
import com.redis.spring.batch.common.DataType;
import com.redis.spring.batch.common.KeyValue;
import com.redis.spring.batch.common.SimpleBatchWriteOperation;
import com.redis.spring.batch.util.Predicates;
import com.redis.spring.batch.writer.BatchWriteOperation;
import com.redis.spring.batch.writer.operation.Del;
import com.redis.spring.batch.writer.operation.ExpireAt;
import com.redis.spring.batch.writer.operation.Hset;
import com.redis.spring.batch.writer.operation.JsonSet;
import com.redis.spring.batch.writer.operation.Noop;
import com.redis.spring.batch.writer.operation.RpushAll;
import com.redis.spring.batch.writer.operation.SaddAll;
import com.redis.spring.batch.writer.operation.Set;
import com.redis.spring.batch.writer.operation.TsAddAll;
import com.redis.spring.batch.writer.operation.XAddAll;
import com.redis.spring.batch.writer.operation.ZaddAll;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.StreamMessage;
import io.lettuce.core.XAddArgs;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class StructBatchWriteOperation<K, V>
implements BatchWriteOperation<K, V, KeyValue<K>> {
    private final Collector<KeyValue<K>, ?, Map<DataType, List<KeyValue<K>>>> groupByType = Collectors.groupingBy(KeyValue::getType);
    private final Predicate<KeyValue<K>> expirePredicate = Predicates.and(this.existPredicate(), k -> k.getTtl() > 0L);
    private Predicate<KeyValue<K>> deletePredicate = Predicates.negate(this.existPredicate());
    private final BatchWriteOperation<K, V, KeyValue<K>> deleteOperation = this.deleteOperation();
    private final BatchWriteOperation<K, V, KeyValue<K>> expireOperation = this.expireOperation();
    private final BatchWriteOperation<K, V, KeyValue<K>> hashOperation = this.hashOperation();
    private final BatchWriteOperation<K, V, KeyValue<K>> jsonOperation = this.jsonOperation();
    private final BatchWriteOperation<K, V, KeyValue<K>> listOperation = this.listOperation();
    private final BatchWriteOperation<K, V, KeyValue<K>> setOperation = this.setOperation();
    private final BatchWriteOperation<K, V, KeyValue<K>> streamOperation = this.streamOperation();
    private final BatchWriteOperation<K, V, KeyValue<K>> stringOperation = this.stringOperation();
    private final BatchWriteOperation<K, V, KeyValue<K>> timeseriesOperation = this.timeseriesOperation();
    private final BatchWriteOperation<K, V, KeyValue<K>> zsetOperation = this.zsetOperation();
    private final BatchWriteOperation<K, V, KeyValue<K>> noOperation = this.noOperation();

    private Predicate<KeyValue<K>> existPredicate() {
        return KeyValue::exists;
    }

    private BatchWriteOperation<K, V, KeyValue<K>> noOperation() {
        return new SimpleBatchWriteOperation(new Noop());
    }

    public void setOverwrite(boolean overwrite) {
        if (overwrite) {
            this.deletePredicate = Predicates.isTrue();
        }
    }

    @Override
    public List<RedisFuture<Object>> execute(BaseRedisAsyncCommands<K, V> commands, List<KeyValue<K>> items) {
        ArrayList<RedisFuture<Object>> futures = new ArrayList<RedisFuture<Object>>();
        List toDelete = items.stream().filter(this.deletePredicate).collect(Collectors.toList());
        futures.addAll(this.deleteOperation.execute(commands, toDelete));
        Map<DataType, List<KeyValue<K>>> toWrite = items.stream().filter(KeyValue::exists).collect(this.groupByType);
        for (Map.Entry<DataType, List<KeyValue<K>>> entry : toWrite.entrySet()) {
            futures.addAll(this.operation(entry.getKey()).execute(commands, entry.getValue()));
        }
        List toExpire = items.stream().filter(this.expirePredicate).collect(Collectors.toList());
        futures.addAll(this.expireOperation.execute(commands, toExpire));
        return futures;
    }

    private BatchWriteOperation<K, V, KeyValue<K>> operation(DataType type) {
        switch (type) {
            case HASH: {
                return this.hashOperation;
            }
            case JSON: {
                return this.jsonOperation;
            }
            case LIST: {
                return this.listOperation;
            }
            case SET: {
                return this.setOperation;
            }
            case STREAM: {
                return this.streamOperation;
            }
            case STRING: {
                return this.stringOperation;
            }
            case TIMESERIES: {
                return this.timeseriesOperation;
            }
            case ZSET: {
                return this.zsetOperation;
            }
        }
        return this.noOperation;
    }

    private SimpleBatchWriteOperation<K, V, KeyValue<K>> hashOperation() {
        Hset operation = new Hset();
        operation.setKeyFunction(KeyValue::getKey);
        operation.setMapFunction(this::value);
        return new SimpleBatchWriteOperation(operation);
    }

    private SimpleBatchWriteOperation<K, V, KeyValue<K>> stringOperation() {
        Set<Object, Object, KeyValue> operation = new Set<Object, Object, KeyValue>();
        operation.setKeyFunction(KeyValue::getKey);
        operation.setValueFunction(this::value);
        return new SimpleBatchWriteOperation(operation);
    }

    private XAddArgs xaddArgs(StreamMessage<K, V> message) {
        XAddArgs args = new XAddArgs();
        if (message.getId() != null) {
            args.id(message.getId());
        }
        return args;
    }

    private XAddAll<K, V, KeyValue<K>> streamOperation() {
        XAddAll operation = new XAddAll();
        operation.setMessagesFunction(this::value);
        operation.setArgsFunction(this::xaddArgs);
        return operation;
    }

    private TsAddAll<K, V, KeyValue<K>> timeseriesOperation() {
        TsAddAll operation = new TsAddAll();
        operation.setKeyFunction(KeyValue::getKey);
        operation.setOptions(((AddOptions.Builder)AddOptions.builder().policy(DuplicatePolicy.LAST)).build());
        operation.setSamplesFunction(this::value);
        return operation;
    }

    private SimpleBatchWriteOperation<K, V, KeyValue<K>> zsetOperation() {
        ZaddAll operation = new ZaddAll();
        operation.setKeyFunction(KeyValue::getKey);
        operation.setValuesFunction(this::value);
        return new SimpleBatchWriteOperation(operation);
    }

    private SimpleBatchWriteOperation<K, V, KeyValue<K>> setOperation() {
        SaddAll operation = new SaddAll();
        operation.setKeyFunction(KeyValue::getKey);
        operation.setValuesFunction(this::value);
        return new SimpleBatchWriteOperation(operation);
    }

    private SimpleBatchWriteOperation<K, V, KeyValue<K>> listOperation() {
        RpushAll operation = new RpushAll();
        operation.setKeyFunction(KeyValue::getKey);
        operation.setValuesFunction(this::value);
        return new SimpleBatchWriteOperation(operation);
    }

    private SimpleBatchWriteOperation<K, V, KeyValue<K>> jsonOperation() {
        JsonSet<Object, Object, KeyValue> operation = new JsonSet<Object, Object, KeyValue>();
        operation.setKeyFunction(KeyValue::getKey);
        operation.setValueFunction(this::value);
        return new SimpleBatchWriteOperation(operation);
    }

    private SimpleBatchWriteOperation<K, V, KeyValue<K>> deleteOperation() {
        Del operation = new Del();
        operation.setKeyFunction(KeyValue::getKey);
        return new SimpleBatchWriteOperation(operation);
    }

    private SimpleBatchWriteOperation<K, V, KeyValue<K>> expireOperation() {
        ExpireAt operation = new ExpireAt();
        operation.setKeyFunction(KeyValue::getKey);
        operation.setEpochFunction(KeyValue::getTtl);
        return new SimpleBatchWriteOperation(operation);
    }

    private <O> O value(KeyValue<K> struct) {
        return (O)struct.getValue();
    }
}

