/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.lettucemod.api.async.RediSearchAsyncCommands;
import com.redis.lettucemod.search.Suggestion;
import com.redis.spring.batch.util.Predicates;
import com.redis.spring.batch.writer.operation.AbstractKeyWriteOperation;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import java.util.function.Function;
import java.util.function.Predicate;

public class Sugadd<K, V, T>
extends AbstractKeyWriteOperation<K, V, T> {
    private Function<T, Suggestion<V>> suggestionFunction;
    private Predicate<T> incrPredicate = Predicates.isFalse();

    public void setSuggestionFunction(Function<T, Suggestion<V>> function) {
        this.suggestionFunction = function;
    }

    public void setIncr(boolean incr) {
        this.incrPredicate = t -> incr;
    }

    public void setIncrPredicate(Predicate<T> predicate) {
        this.incrPredicate = predicate;
    }

    @Override
    protected RedisFuture<Long> execute(BaseRedisAsyncCommands<K, V> commands, T item, K key) {
        RediSearchAsyncCommands searchCommands = (RediSearchAsyncCommands)commands;
        Suggestion<V> suggestion = this.suggestionFunction.apply(item);
        if (this.incrPredicate.test(item)) {
            return searchCommands.ftSugaddIncr(key, suggestion);
        }
        return searchCommands.ftSugadd(key, suggestion);
    }
}

