/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.lettucemod.api.async.RedisTimeSeriesAsyncCommands;
import com.redis.lettucemod.timeseries.AddOptions;
import com.redis.lettucemod.timeseries.Sample;
import com.redis.spring.batch.writer.operation.AbstractKeyWriteOperation;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import java.util.function.Function;

public class TsAdd<K, V, T>
extends AbstractKeyWriteOperation<K, V, T> {
    private Function<T, Sample> sampleFunction;
    private Function<T, AddOptions<K, V>> optionsFunction = t -> null;

    public void setSampleFunction(Function<T, Sample> function) {
        this.sampleFunction = function;
    }

    public void setOptions(AddOptions<K, V> options) {
        this.optionsFunction = t -> options;
    }

    public void setOptionsFunction(Function<T, AddOptions<K, V>> function) {
        this.optionsFunction = function;
    }

    @Override
    protected RedisFuture<Long> execute(BaseRedisAsyncCommands<K, V> commands, T item, K key) {
        RedisTimeSeriesAsyncCommands timeseriesCommands = (RedisTimeSeriesAsyncCommands)commands;
        AddOptions<K, V> options = this.optionsFunction.apply(item);
        Sample sample = this.sampleFunction.apply(item);
        if (sample == null) {
            return null;
        }
        return timeseriesCommands.tsAdd(key, sample, options);
    }
}

