/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.spring.batch.writer.BatchWriteOperation;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.StreamMessage;
import io.lettuce.core.XAddArgs;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import io.lettuce.core.api.async.RedisStreamAsyncCommands;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.springframework.util.CollectionUtils;

public class XAddAll<K, V, T>
implements BatchWriteOperation<K, V, T> {
    private Function<T, Collection<StreamMessage<K, V>>> messagesFunction;
    private Function<StreamMessage<K, V>, XAddArgs> argsFunction = m -> new XAddArgs().id(m.getId());

    public void setMessagesFunction(Function<T, Collection<StreamMessage<K, V>>> function) {
        this.messagesFunction = function;
    }

    public void setArgs(XAddArgs args) {
        this.argsFunction = t -> args;
    }

    public void setArgsFunction(Function<StreamMessage<K, V>, XAddArgs> function) {
        this.argsFunction = function;
    }

    @Override
    public List<RedisFuture<Object>> execute(BaseRedisAsyncCommands<K, V> commands, List<T> items) {
        if (CollectionUtils.isEmpty(items)) {
            return Collections.emptyList();
        }
        ArrayList<RedisFuture<Object>> futures = new ArrayList<RedisFuture<Object>>();
        RedisStreamAsyncCommands streamCommands = (RedisStreamAsyncCommands)commands;
        for (T item : items) {
            Collection<StreamMessage<K, V>> messages = this.messagesFunction.apply(item);
            if (CollectionUtils.isEmpty(messages)) continue;
            for (StreamMessage<K, V> message : messages) {
                XAddArgs args = this.argsFunction.apply(message);
                futures.add((RedisFuture<Object>)streamCommands.xadd(message.getStream(), args, message.getBody()));
            }
        }
        return futures;
    }
}

