/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.spring.batch.writer.operation.AbstractKeyWriteOperation;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.ScoredValue;
import io.lettuce.core.ZAddArgs;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import io.lettuce.core.api.async.RedisSortedSetAsyncCommands;
import java.util.function.Function;

public class Zadd<K, V, T>
extends AbstractKeyWriteOperation<K, V, T> {
    private Function<T, ScoredValue<V>> valueFunction;
    private Function<T, ZAddArgs> argsFunction = t -> null;

    public void setArgs(ZAddArgs args) {
        this.argsFunction = t -> args;
    }

    public void setArgsFunction(Function<T, ZAddArgs> function) {
        this.argsFunction = function;
    }

    public void setValueFunction(Function<T, ScoredValue<V>> function) {
        this.valueFunction = function;
    }

    @Override
    protected RedisFuture<Long> execute(BaseRedisAsyncCommands<K, V> commands, T item, K key) {
        ZAddArgs args = this.argsFunction.apply(item);
        ScoredValue<V> value = this.valueFunction.apply(item);
        return ((RedisSortedSetAsyncCommands)commands).zadd(key, args, new ScoredValue[]{value});
    }
}

