/*
 * Decompiled with CFR 0.152.
 */
package com.redis.testcontainers;

import com.redis.testcontainers.AbstractRedisContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public abstract class AbstractRedisServerContainer<C extends AbstractRedisServerContainer<C>>
extends AbstractRedisContainer<C> {
    public static final int REDIS_PORT = 6379;

    protected AbstractRedisServerContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    protected AbstractRedisServerContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        this.addExposedPorts(new int[]{6379});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Ready to accept connections.*\\n", (int)1));
    }

    public C withKeyspaceNotifications() {
        this.withCopyFileToContainer(MountableFile.forClasspathResource((String)"redis-keyspace-notifications.conf"), "/data/redis.conf");
        this.withCommand(new String[]{"redis-server", "/data/redis.conf"});
        return (C)((Object)this);
    }

    @Override
    public String getRedisURI() {
        return this.redisURI(this.getHost(), this.getFirstMappedPort());
    }

    @Override
    public boolean isCluster() {
        return false;
    }
}

