/*
 * Decompiled with CFR 0.152.
 */
package com.redis.testcontainers;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.InspectExecResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.redis.enterprise.Admin;
import com.redis.enterprise.Database;
import com.redis.testcontainers.AbstractRedisContainer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.output.FrameConsumerResultCallback;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.ToStringConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.shaded.org.apache.commons.lang3.ClassUtils;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.TestEnvironment;

public class RedisEnterpriseContainer
extends AbstractRedisContainer<RedisEnterpriseContainer> {
    private static final Logger log = LoggerFactory.getLogger(RedisEnterpriseContainer.class);
    public static final String ADMIN_USERNAME = "testcontainers@redis.com";
    public static final String ADMIN_PASSWORD = "redis123";
    public static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"redislabs/redis");
    public static final String DEFAULT_TAG = "latest";
    public static final int ADMIN_PORT = 8443;
    public static final int DEFAULT_DATABASE_PORT = 12000;
    private static final String NODE_EXTERNAL_ADDR = "0.0.0.0";
    private static final int DEFAULT_SHARD_COUNT = 2;
    private static final String DEFAULT_DATABASE_NAME = "testcontainers";
    private static final String RLADMIN = "/opt/redislabs/bin/rladmin";
    private static final Long EXIT_CODE_SUCCESS = 0L;
    private Database database = Database.name((String)"testcontainers").shardCount(2).port(12000).build();

    public RedisEnterpriseContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public RedisEnterpriseContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        this.addFixedExposedPort(9443, 9443);
        this.addFixedExposedPort(8443, 8443);
        this.addFixedExposedPort(this.database.getPort(), this.database.getPort());
        this.withPrivilegedMode(true);
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*success: job_scheduler entered RUNNING state, process has stayed up for.*\\n", (int)1));
    }

    public Database getDatabase() {
        return this.database;
    }

    public RedisEnterpriseContainer withDatabase(Database database) {
        this.database = database;
        if (database.getPort() == null) {
            database.setPort(12000);
        }
        return this;
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        super.containerIsStarted(containerInfo);
        try (Admin admin = new Admin(ADMIN_USERNAME, ADMIN_PASSWORD.toCharArray());){
            admin.setHost(this.getHost());
            log.info("Waiting for cluster bootstrap");
            admin.waitForBoostrap();
            this.createCluster();
            Database response = admin.createDatabase(this.database);
            log.info("Created database {} with UID {}", (Object)response.getName(), (Object)response.getUid());
        }
        catch (Exception e) {
            throw new ContainerLaunchException("Could not initialize Redis Enterprise container", (Throwable)e);
        }
    }

    private void createCluster() {
        log.info("Creating cluster");
        if (!TestEnvironment.dockerExecutionDriverSupportsExec()) {
            throw new UnsupportedOperationException("Your docker daemon is running the \"lxc\" driver, which doesn't support \"docker exec\".");
        }
        InspectContainerResponse containerInfo = this.getContainerInfo();
        if (!this.isRunning(containerInfo)) {
            throw new IllegalStateException("execInContainer can only be used while the Container is running");
        }
        String containerId = containerInfo.getId();
        String containerName = containerInfo.getName();
        DockerClient dockerClient = DockerClientFactory.instance().client();
        String[] commands = new String[]{RLADMIN, "cluster", "create", "name", "cluster.local", "username", ADMIN_USERNAME, "password", ADMIN_PASSWORD, "external_addr", NODE_EXTERNAL_ADDR};
        log.debug("{}: Running \"exec\" command: {}", (Object)containerName, (Object)commands);
        ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)dockerClient.execCreateCmd(containerId).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withCmd(commands).withPrivileged(Boolean.valueOf(true)).exec();
        ToStringConsumer stdoutConsumer = new ToStringConsumer();
        ToStringConsumer stderrConsumer = new ToStringConsumer();
        try (FrameConsumerResultCallback callback = new FrameConsumerResultCallback();){
            callback.addConsumer(OutputFrame.OutputType.STDOUT, (Consumer)stdoutConsumer);
            callback.addConsumer(OutputFrame.OutputType.STDERR, (Consumer)stderrConsumer);
            ((FrameConsumerResultCallback)dockerClient.execStartCmd(execCreateCmdResponse.getId()).exec((ResultCallback)callback)).awaitCompletion();
            InspectExecResponse execResponse = dockerClient.inspectExecCmd(execCreateCmdResponse.getId()).exec();
            if (EXIT_CODE_SUCCESS.equals(execResponse.getExitCodeLong())) {
                return;
            }
            if (log.isErrorEnabled()) {
                log.error("Could not create cluster: {}", (Object)stderrConsumer.toString(StandardCharsets.UTF_8));
            }
            throw new ContainerLaunchException("Could not create cluster");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ContainerLaunchException("Could not create cluster", (Throwable)e);
        }
        catch (IOException e) {
            log.error("Could not close result callback", (Throwable)e);
            return;
        }
    }

    @Override
    public String getRedisURI() {
        return this.redisURI(this.getHost(), this.database.getPort());
    }

    @Override
    public boolean isCluster() {
        return this.database.isOssCluster();
    }

    @Override
    public String toString() {
        return ClassUtils.getShortClassName(RedisEnterpriseContainer.class);
    }

    private boolean isRunning(InspectContainerResponse containerInfo) {
        try {
            return containerInfo != null && Boolean.TRUE.equals(containerInfo.getState().getRunning());
        }
        catch (DockerException e) {
            return false;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.database);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RedisEnterpriseContainer other = (RedisEnterpriseContainer)((Object)obj);
        return Objects.equals(this.database, other.database);
    }
}

