/*
 * Decompiled with CFR 0.152.
 */
package com.redis.testcontainers;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.InspectExecResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.redis.testcontainers.RedisServer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.FrameConsumerResultCallback;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.ToStringConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.shaded.org.apache.commons.lang3.ClassUtils;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.TestEnvironment;

public abstract class AbstractRedisEnterpriseContainer<T extends AbstractRedisEnterpriseContainer<T>>
extends GenericContainer<T>
implements RedisServer {
    public static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"redislabs/redis");
    public static final String DEFAULT_TAG = "latest";
    private static final Logger log = LoggerFactory.getLogger(AbstractRedisEnterpriseContainer.class);
    private static final int WEB_UI_PORT = 8443;
    private static final String NODE_EXTERNAL_ADDR = "0.0.0.0";
    private static final String RLADMIN = "/opt/redislabs/bin/rladmin";
    private static final Long EXIT_CODE_SUCCESS = 0L;

    protected AbstractRedisEnterpriseContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    protected AbstractRedisEnterpriseContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        this.addFixedExposedPort(8443, 8443);
        this.withPrivilegedMode(true);
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*success: job_scheduler entered RUNNING state, process has stayed up for.*\\n", (int)1));
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        super.containerIsStarted(containerInfo);
        try {
            this.createCluster();
        }
        catch (Exception e) {
            throw new ContainerLaunchException("Could not initialize Redis Enterprise", (Throwable)e);
        }
    }

    protected void createCluster() throws Exception {
        log.info("Creating cluster");
        if (!TestEnvironment.dockerExecutionDriverSupportsExec()) {
            throw new UnsupportedOperationException("Your docker daemon is running the \"lxc\" driver, which doesn't support \"docker exec\".");
        }
        InspectContainerResponse containerInfo = this.getContainerInfo();
        if (!this.isRunning(containerInfo)) {
            throw new IllegalStateException("execInContainer can only be used while the Container is running");
        }
        String containerId = containerInfo.getId();
        String containerName = containerInfo.getName();
        DockerClient dockerClient = DockerClientFactory.instance().client();
        String[] commands = new String[]{RLADMIN, "cluster", "create", "name", "cluster.local", "username", this.getAdminUserName(), "password", this.getAdminPassword(), "external_addr", NODE_EXTERNAL_ADDR};
        log.debug("{}: Running \"exec\" command: {}", (Object)containerName, (Object)commands);
        ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)dockerClient.execCreateCmd(containerId).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withCmd(commands).withPrivileged(Boolean.valueOf(true)).exec();
        ToStringConsumer stdoutConsumer = new ToStringConsumer();
        ToStringConsumer stderrConsumer = new ToStringConsumer();
        try (FrameConsumerResultCallback callback = new FrameConsumerResultCallback();){
            callback.addConsumer(OutputFrame.OutputType.STDOUT, (Consumer)stdoutConsumer);
            callback.addConsumer(OutputFrame.OutputType.STDERR, (Consumer)stderrConsumer);
            ((FrameConsumerResultCallback)dockerClient.execStartCmd(execCreateCmdResponse.getId()).exec((ResultCallback)callback)).awaitCompletion();
            InspectExecResponse execResponse = dockerClient.inspectExecCmd(execCreateCmdResponse.getId()).exec();
            if (EXIT_CODE_SUCCESS.equals(execResponse.getExitCodeLong())) {
                return;
            }
            if (log.isErrorEnabled()) {
                log.error("Could not create cluster: {}", (Object)stderrConsumer.toString(StandardCharsets.UTF_8));
            }
            throw new ContainerLaunchException("Could not create cluster");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ContainerLaunchException("Could not create cluster", (Throwable)e);
        }
        catch (IOException e) {
            log.error("Could not close result callback", (Throwable)e);
            return;
        }
    }

    public String toString() {
        return ClassUtils.getShortClassName(this.getClass());
    }

    protected abstract String getAdminPassword();

    protected abstract String getAdminUserName();

    private boolean isRunning(InspectContainerResponse containerInfo) {
        try {
            return containerInfo != null && Boolean.TRUE.equals(containerInfo.getState().getRunning());
        }
        catch (DockerException e) {
            return false;
        }
    }

    @Override
    public String getRedisHost() {
        return this.getHost();
    }
}

