/*
 * Decompiled with CFR 0.152.
 */
package com.redis.testcontainers.junit.jupiter;

import com.redis.lettucemod.RedisModulesClient;
import com.redis.lettucemod.api.StatefulRedisModulesConnection;
import com.redis.lettucemod.api.async.RedisModulesAsyncCommands;
import com.redis.lettucemod.api.reactive.RedisModulesReactiveCommands;
import com.redis.lettucemod.api.sync.RedisModulesCommands;
import com.redis.lettucemod.cluster.RedisModulesClusterClient;
import com.redis.testcontainers.RedisServer;
import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.RedisClient;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;

public class RedisTestContext
implements AutoCloseable {
    private final RedisServer server;
    private AbstractRedisClient client;
    private StatefulRedisModulesConnection<String, String> connection;
    private StatefulRedisPubSubConnection<String, String> pubSubConnection;

    public RedisTestContext(RedisServer server) {
        this.server = server;
    }

    public String toString() {
        return this.server.toString();
    }

    public RedisServer getServer() {
        return this.server;
    }

    public AbstractRedisClient getClient() {
        if (this.client == null) {
            String uri = this.server.getRedisURI();
            this.client = this.server.isCluster() ? RedisModulesClusterClient.create((String)uri) : RedisModulesClient.create((String)uri);
        }
        return this.client;
    }

    public StatefulRedisModulesConnection<String, String> getConnection() {
        if (this.connection == null) {
            this.connection = this.connection();
        }
        return this.connection;
    }

    public StatefulRedisPubSubConnection<String, String> getPubSubConnection() {
        if (this.pubSubConnection == null) {
            this.pubSubConnection = this.pubSubConnection();
        }
        return this.pubSubConnection;
    }

    private StatefulRedisModulesConnection<String, String> connection() {
        if (this.server.isCluster()) {
            return ((RedisModulesClusterClient)this.getClient()).connect();
        }
        return ((RedisModulesClient)this.getClient()).connect();
    }

    private StatefulRedisPubSubConnection<String, String> pubSubConnection() {
        if (this.server.isCluster()) {
            return ((RedisModulesClusterClient)this.getClient()).connectPubSub();
        }
        return ((RedisModulesClient)this.getClient()).connectPubSub();
    }

    public RedisModulesCommands<String, String> sync() {
        return this.getConnection().sync();
    }

    public RedisModulesAsyncCommands<String, String> async() {
        return this.getConnection().async();
    }

    public RedisModulesReactiveCommands<String, String> reactive() {
        return this.getConnection().reactive();
    }

    @Override
    public void close() {
        if (this.pubSubConnection != null) {
            this.pubSubConnection.close();
            this.pubSubConnection = null;
        }
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        if (this.client != null) {
            this.client.shutdown();
            this.client.getResources().shutdown();
            this.client = null;
        }
    }

    public RedisClient getRedisClient() {
        return (RedisClient)this.getClient();
    }

    public RedisClusterClient getRedisClusterClient() {
        return (RedisClusterClient)this.getClient();
    }

    public boolean isCluster() {
        return this.server.isCluster();
    }

    public String getRedisURI() {
        return this.server.getRedisURI();
    }
}

