/*
 * Decompiled with CFR 0.152.
 */
package com.redis.testcontainers.junit;

import com.redis.testcontainers.RedisServer;
import com.redis.testcontainers.junit.RedisTestContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class AbstractTestcontainersRedisTestBase {
    private static final Logger log = LoggerFactory.getLogger(AbstractTestcontainersRedisTestBase.class);
    private Map<RedisServer, RedisTestContext> contexts = new LinkedHashMap<RedisServer, RedisTestContext>();

    protected abstract Collection<RedisServer> redisServers();

    protected Collection<RedisServer> testRedisServers() {
        return this.contexts.keySet();
    }

    @BeforeAll
    protected void setup() {
        Collection<RedisServer> allRedisServers = this.redisServers();
        Assumptions.assumeTrue((boolean)allRedisServers.stream().anyMatch(RedisServer::isEnabled));
        for (RedisServer server : allRedisServers) {
            if (server.isEnabled()) {
                log.info("Starting container {}", (Object)server);
                server.start();
                this.contexts.put(server, new RedisTestContext(server));
                continue;
            }
            log.info("Container {} disabled", (Object)server);
        }
    }

    protected RedisTestContext removeRedisTestContext(RedisServer server) {
        return this.contexts.remove(server);
    }

    private List<RedisTestContext> contexts(Collection<RedisServer> servers) {
        ArrayList<RedisTestContext> testContexts = new ArrayList<RedisTestContext>();
        for (RedisServer server : servers) {
            if (!this.contexts.containsKey(server)) continue;
            testContexts.add(this.contexts.get(server));
        }
        return testContexts;
    }

    @BeforeEach
    protected void flushAll() {
        this.contexts.forEach((k, v) -> {
            if (k.isEnabled()) {
                v.sync().flushall();
                Awaitility.await().until(() -> v.sync().dbsize() == 0L);
            }
        });
    }

    @AfterAll
    protected void teardown() {
        this.contexts.forEach((k, v) -> {
            v.close();
            k.close();
        });
        this.contexts.clear();
    }

    public RedisTestContext getContext(RedisServer server) {
        return this.contexts.get(server);
    }

    public List<RedisTestContext> getAllContexts() {
        return new ArrayList<RedisTestContext>(this.contexts.values());
    }

    public List<RedisTestContext> getTestContexts() {
        return this.contexts(this.testRedisServers());
    }
}

