/*
 * Decompiled with CFR 0.152.
 */
package com.redis.testcontainers;

import com.redis.testcontainers.RedisServer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.shaded.org.apache.commons.lang.ClassUtils;

public class RedisClusterContainer
extends GenericContainer<RedisClusterContainer>
implements RedisServer {
    private static final String ENV_MASTERS = "MASTERS";
    private static final String ENV_SLAVES_PER_MASTER = "SLAVES_PER_MASTER";
    private static final String ENV_INITIAL_PORT = "INITIAL_PORT";
    private static final String ENV_IP = "IP";
    private static final String DEFAULT_IMAGE_NAME = "grokzen/redis-cluster:6.2.1";
    private static final String KEYSPACE_NOTIFICATIONS_IMAGE_NAME = "jruaux/redis-cluster:6.2.1";
    private static final int DEFAULT_INITIAL_PORT = 7000;
    private static final int DEFAULT_MASTERS = 3;
    private static final int DEFAULT_SLAVES_PER_MASTER = 0;
    private static final String DEFAULT_IP = "0.0.0.0";
    private int initialPort = 7000;
    private int masters = 3;
    private int slavesPerMaster = 0;

    public RedisClusterContainer() {
        this(DEFAULT_IMAGE_NAME);
    }

    protected RedisClusterContainer(String dockerImageName) {
        super(dockerImageName);
        this.withIP(DEFAULT_IP);
        this.update();
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Cluster state changed: ok*\\n", (int)1));
    }

    @Override
    public boolean isCluster() {
        return true;
    }

    public RedisClusterContainer withKeyspaceNotifications() {
        this.setDockerImageName(KEYSPACE_NOTIFICATIONS_IMAGE_NAME);
        return this;
    }

    public RedisClusterContainer withIP(String ip) {
        this.withEnv(ENV_IP, ip);
        return this;
    }

    private RedisClusterContainer update() {
        this.withEnv(ENV_INITIAL_PORT, String.valueOf(this.initialPort));
        this.withEnv(ENV_MASTERS, String.valueOf(this.masters));
        this.withEnv(ENV_SLAVES_PER_MASTER, String.valueOf(this.slavesPerMaster));
        for (int port : this.ports()) {
            this.addFixedExposedPort(port, port);
        }
        return this;
    }

    private int[] ports() {
        int totalNodes = this.masters * (this.slavesPerMaster + 1);
        int[] ports = new int[totalNodes];
        for (int index = 0; index < totalNodes; ++index) {
            ports[index] = this.initialPort + index;
        }
        return ports;
    }

    public String[] getRedisURIs() {
        int[] ports = this.ports();
        String[] redisURIs = new String[ports.length];
        for (int index = 0; index < ports.length; ++index) {
            redisURIs[index] = RedisServer.redisURI(this.getHost(), ports[index]);
        }
        return redisURIs;
    }

    @Override
    public String getRedisURI() {
        return this.getRedisURIs()[0];
    }

    public RedisClusterContainer withMasters(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("Count must be greater than zero");
        }
        this.masters = count;
        return this.update();
    }

    public RedisClusterContainer withSlavesPerMaster(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be zero or greater");
        }
        this.slavesPerMaster = count;
        return this.update();
    }

    public RedisClusterContainer withInitialPort(int port) {
        this.initialPort = port;
        return this.update();
    }

    public String toString() {
        return ClassUtils.getShortClassName(this.getClass());
    }
}

