/*
 * Decompiled with CFR 0.152.
 */
package com.redis.testcontainers;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import com.redis.testcontainers.RedisServer;
import com.redis.testcontainers.support.RetryCallable;
import com.redis.testcontainers.support.enterprise.DatabaseProvisioner;
import com.redis.testcontainers.support.enterprise.RestAPI;
import com.redis.testcontainers.support.enterprise.rest.Bootstrap;
import com.redis.testcontainers.support.enterprise.rest.Database;
import com.redis.testcontainers.support.enterprise.rest.DatabaseCreateResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.FrameConsumerResultCallback;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.ToStringConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.shaded.org.apache.commons.lang.ClassUtils;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.TestEnvironment;

public class RedisEnterpriseContainer
extends GenericContainer<RedisEnterpriseContainer>
implements RedisServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisEnterpriseContainer.class);
    public static final String MODULE_BLOOM = "bf";
    public static final String MODULE_GEARS = "rg";
    public static final String MODULE_GRAPH = "graph";
    public static final String MODULE_JSON = "ReJSON";
    public static final String MODULE_SEARCH = "search";
    public static final String MODULE_TIMESERIES = "timeseries";
    public static final String ADMIN_USERNAME = "testcontainers@redis.com";
    public static final String ADMIN_PASSWORD = "redis123";
    public static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"redislabs/redis");
    private static final String NODE_EXTERNAL_ADDR = "0.0.0.0";
    private static final int DEFAULT_SHARD_COUNT = 2;
    private static final String DEFAULT_DATABASE_NAME = "testcontainers";
    private static final String RLADMIN = "/opt/redislabs/bin/rladmin";
    private static final Duration DEFAULT_BOOTSTRAP_TIMEOUT = Duration.ofSeconds(30L);
    private static final Duration DEFAULT_BOOTSTRAP_RETRY_DELAY = Duration.ofSeconds(3L);
    private static final Duration DEFAULT_CLUSTER_CREATE_TIMEOUT = Duration.ofSeconds(10L);
    private static final Duration DEFAULT_CLUSTER_CREATE_RETRY_DELAY = Duration.ofSeconds(3L);
    public static final int ADMIN_PORT = 8443;
    public static final int ENDPOINT_PORT = 12000;
    private DatabaseProvisioner.Options provisionerOptions = DatabaseProvisioner.Options.builder().build();
    private String databaseName = "testcontainers";
    private int shardCount = 2;
    private boolean ossCluster;
    private Database.Module[] modules = new Database.Module[0];
    private Duration bootstrapTimeout = DEFAULT_BOOTSTRAP_TIMEOUT;
    private Duration bootstrapRetryDelay = DEFAULT_BOOTSTRAP_RETRY_DELAY;
    private Duration clusterCreateTimeout = DEFAULT_CLUSTER_CREATE_TIMEOUT;
    private Duration clusterCreateRetryDelay = DEFAULT_CLUSTER_CREATE_RETRY_DELAY;

    public RedisEnterpriseContainer() {
        super(DEFAULT_IMAGE_NAME);
        this.addFixedExposedPort(9443, 9443);
        this.addFixedExposedPort(8443, 8443);
        this.addFixedExposedPort(12000, 12000);
        this.withPrivilegedMode(true);
        this.withPublishAllPorts(false);
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*success: job_scheduler entered RUNNING state, process has stayed up for.*\\n", (int)1));
    }

    public RedisEnterpriseContainer withBootstrapTimeout(Duration timeout) {
        this.bootstrapTimeout = timeout;
        return this;
    }

    public RedisEnterpriseContainer withBootstrapRetryDelay(Duration retryDelay) {
        this.bootstrapRetryDelay = retryDelay;
        return this;
    }

    public RedisEnterpriseContainer withClusterCreateTimeout(Duration timeout) {
        this.clusterCreateTimeout = timeout;
        return this;
    }

    public RedisEnterpriseContainer withClusterCreateRetryDelay(Duration retryDelay) {
        this.clusterCreateRetryDelay = retryDelay;
        return this;
    }

    public RedisEnterpriseContainer withProvisionerOptions(DatabaseProvisioner.Options options) {
        this.provisionerOptions = options;
        return this;
    }

    public RedisEnterpriseContainer withShardCount(int shardCount) {
        this.shardCount = shardCount;
        return this;
    }

    public RedisEnterpriseContainer withModules(Database.Module ... modules) {
        this.modules = modules;
        return this;
    }

    public RedisEnterpriseContainer withDatabaseName(String name) {
        this.databaseName = name;
        return this;
    }

    public RedisEnterpriseContainer withOSSCluster() {
        this.ossCluster = true;
        return this;
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        super.containerIsStarted(containerInfo);
        RestAPI restAPI = RestAPI.builder().host(this.getHost()).build();
        this.waitForBootstrap(restAPI);
        String username = ADMIN_USERNAME;
        String password = ADMIN_PASSWORD;
        String externalAddress = NODE_EXTERNAL_ADDR;
        log.info("Creating cluster with username={}, password={}, external_adr={}", new Object[]{username, password, externalAddress});
        this.createCluster(username, password, externalAddress);
        String host = this.getHost();
        log.info("Creating REST API client with username={}, password={}, host={}", new Object[]{username, password, host});
        restAPI.setCredentials(new UsernamePasswordCredentials(username, password.toCharArray()));
        DatabaseProvisioner provisioner = DatabaseProvisioner.restAPI(restAPI).options(this.provisionerOptions).build();
        Database database = Database.name(this.databaseName).port(12000).shardCount(this.shardCount).ossCluster(this.ossCluster).modules(this.modules).build();
        DatabaseCreateResponse response = provisioner.create(database);
        log.info("Created database {} with UID {}", (Object)database.getName(), (Object)response.getUid());
    }

    private void waitForBootstrap(RestAPI restAPI) throws Exception {
        RetryCallable.delegate(() -> {
            log.info("Checking bootstrap status");
            Bootstrap bootstrap = restAPI.bootstrap();
            if ("idle".equals(bootstrap.getStatus().getState())) {
                return bootstrap;
            }
            throw new ContainerLaunchException("Timed out waiting for bootstrap");
        }).sleep(this.bootstrapRetryDelay).timeout(this.bootstrapTimeout).call();
    }

    private void createCluster(String username, String password, String externalAddress) {
        try {
            RetryCallable.delegate(() -> {
                ExecResult result = this.execute(RLADMIN, "cluster", "create", "name", "cluster.local", "username", username, "password", password, "external_addr", externalAddress);
                if (result.getExitCode() == 0) {
                    return result;
                }
                throw new Exception("Failed to create cluster: " + result.getStderr() + " " + result.getStdout());
            }).sleep(this.clusterCreateRetryDelay).timeout(this.clusterCreateTimeout).call();
        }
        catch (Exception e) {
            throw new ContainerLaunchException("Could not create Redis Enterprise cluster", (Throwable)e);
        }
    }

    @Override
    public String getRedisURI() {
        return RedisServer.redisURI(this.getHost(), 12000);
    }

    @Override
    public boolean isCluster() {
        return this.ossCluster;
    }

    public String toString() {
        return ClassUtils.getShortClassName(this.getClass());
    }

    public ExecResult execute(String ... command) throws UnsupportedOperationException, IOException, InterruptedException {
        if (!TestEnvironment.dockerExecutionDriverSupportsExec()) {
            throw new UnsupportedOperationException("Your docker daemon is running the \"lxc\" driver, which doesn't support \"docker exec\".");
        }
        InspectContainerResponse containerInfo = this.getContainerInfo();
        if (!this.isRunning(containerInfo)) {
            throw new IllegalStateException("execInContainer can only be used while the Container is running");
        }
        String containerId = containerInfo.getId();
        String containerName = containerInfo.getName();
        DockerClient dockerClient = DockerClientFactory.instance().client();
        log.debug("{}: Running \"exec\" command: {}", (Object)containerName, (Object)String.join((CharSequence)" ", command));
        ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)dockerClient.execCreateCmd(containerId).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withCmd(command).withPrivileged(Boolean.valueOf(true)).exec();
        ToStringConsumer stdoutConsumer = new ToStringConsumer();
        ToStringConsumer stderrConsumer = new ToStringConsumer();
        try (FrameConsumerResultCallback callback = new FrameConsumerResultCallback();){
            callback.addConsumer(OutputFrame.OutputType.STDOUT, (Consumer)stdoutConsumer);
            callback.addConsumer(OutputFrame.OutputType.STDERR, (Consumer)stderrConsumer);
            ((FrameConsumerResultCallback)dockerClient.execStartCmd(execCreateCmdResponse.getId()).exec((ResultCallback)callback)).awaitCompletion();
        }
        Integer exitCode = dockerClient.inspectExecCmd(execCreateCmdResponse.getId()).exec().getExitCode();
        ExecResult result = new ExecResult(exitCode, stdoutConsumer.toString(StandardCharsets.UTF_8), stderrConsumer.toString(StandardCharsets.UTF_8));
        log.trace("{}: stdout: {}", (Object)containerName, (Object)result.getStdout());
        log.trace("{}: stderr: {}", (Object)containerName, (Object)result.getStderr());
        return result;
    }

    private boolean isRunning(InspectContainerResponse containerInfo) {
        try {
            return containerInfo != null && Boolean.TRUE.equals(containerInfo.getState().getRunning());
        }
        catch (DockerException e) {
            return false;
        }
    }

    static final class ExecResult {
        private final int exitCode;
        private final String stdout;
        private final String stderr;

        @Generated
        public int getExitCode() {
            return this.exitCode;
        }

        @Generated
        public String getStdout() {
            return this.stdout;
        }

        @Generated
        public String getStderr() {
            return this.stderr;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExecResult)) {
                return false;
            }
            ExecResult other = (ExecResult)o;
            if (this.getExitCode() != other.getExitCode()) {
                return false;
            }
            String this$stdout = this.getStdout();
            String other$stdout = other.getStdout();
            if (this$stdout == null ? other$stdout != null : !this$stdout.equals(other$stdout)) {
                return false;
            }
            String this$stderr = this.getStderr();
            String other$stderr = other.getStderr();
            return !(this$stderr == null ? other$stderr != null : !this$stderr.equals(other$stderr));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getExitCode();
            String $stdout = this.getStdout();
            result = result * 59 + ($stdout == null ? 43 : $stdout.hashCode());
            String $stderr = this.getStderr();
            result = result * 59 + ($stderr == null ? 43 : $stderr.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RedisEnterpriseContainer.ExecResult(exitCode=" + this.getExitCode() + ", stdout=" + this.getStdout() + ", stderr=" + this.getStderr() + ")";
        }

        @Generated
        ExecResult(int exitCode, String stdout, String stderr) {
            this.exitCode = exitCode;
            this.stdout = stdout;
            this.stderr = stderr;
        }
    }
}

