/*
 * Decompiled with CFR 0.152.
 */
package com.redis.testcontainers.support.enterprise;

import com.redis.testcontainers.support.RetryCallable;
import com.redis.testcontainers.support.enterprise.RestAPI;
import com.redis.testcontainers.support.enterprise.rest.ActionStatus;
import com.redis.testcontainers.support.enterprise.rest.Command;
import com.redis.testcontainers.support.enterprise.rest.CommandResponse;
import com.redis.testcontainers.support.enterprise.rest.Database;
import com.redis.testcontainers.support.enterprise.rest.DatabaseCreateResponse;
import com.redis.testcontainers.support.enterprise.rest.Module;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.shaded.org.apache.commons.io.IOUtils;

public class DatabaseProvisioner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatabaseProvisioner.class);
    public static final String GEARS_MODULE_FILE = "redisgears.linux-bionic-x64.1.0.6.zip";
    private final RestAPI restAPI;
    private final Options options;

    public DatabaseProvisioner(RestAPI restAPI, Options options) {
        this.restAPI = restAPI;
        this.options = options;
    }

    public static DatabaseProvisionerBuilder restAPI(RestAPI restAPI) {
        return new DatabaseProvisionerBuilder(restAPI);
    }

    public DatabaseCreateResponse create(Database database) throws Exception {
        if (!database.getModuleConfigs().isEmpty()) {
            Map<String, String> moduleIds = this.availableModules();
            for (Database.ModuleConfig moduleConfig : database.getModuleConfigs()) {
                if (!moduleIds.containsKey(moduleConfig.getName())) {
                    log.info("Module {} not installed", (Object)moduleConfig.getName());
                    if ("rg".equals(moduleConfig.getName())) {
                        this.installGears();
                        moduleIds = this.availableModules();
                    }
                }
                moduleConfig.setId(moduleIds.get(moduleConfig.getName()));
            }
        }
        log.info("Creating database: {}", (Object)database);
        DatabaseCreateResponse databaseCreateResponse = this.restAPI.create(database);
        long uid = databaseCreateResponse.getUid();
        return RetryCallable.delegate(() -> {
            log.info("Pinging database {}", (Object)uid);
            CommandResponse response = this.restAPI.command(uid, Command.command("PING").build());
            if (response.getResponse().asBoolean()) {
                return databaseCreateResponse;
            }
            throw new Exception("Database not ready");
        }).sleep(this.options.getPing().getInterval()).timeout(this.options.getPing().getTimeout()).call();
    }

    private Map<String, String> availableModules() throws Exception {
        HashMap<String, String> moduleMap = new HashMap<String, String>();
        for (Module module : this.restAPI.modules()) {
            moduleMap.put(module.getName(), module.getId());
        }
        return moduleMap;
    }

    private void installGears() throws Exception {
        try (InputStream zipInputStream = this.getClass().getClassLoader().getResourceAsStream(GEARS_MODULE_FILE);){
            if (zipInputStream == null) {
                throw new ContainerLaunchException(String.format("Could not find RedisGears module file '%s' in classpath", GEARS_MODULE_FILE));
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)zipInputStream, (OutputStream)baos);
            log.info("Installing module {}", (Object)GEARS_MODULE_FILE);
            String actionUID = this.restAPI.module(GEARS_MODULE_FILE, baos.toByteArray()).getActionUID();
            RetryCallable.delegate(() -> {
                log.info("Checking status of action {}", (Object)actionUID);
                ActionStatus status = this.restAPI.actionStatus(actionUID);
                if ("completed".equals(status.getStatus())) {
                    log.info("Action {} completed", (Object)actionUID);
                    return status;
                }
                log.info("Action {} {}", (Object)actionUID, (Object)status.getStatus());
                throw new ContainerLaunchException("Timed out waiting for module installation to complete. Action UID: " + actionUID);
            }).sleep(this.options.getModuleInstallation().getCheckInterval()).timeout(this.options.getModuleInstallation().getTimeout()).call();
        }
    }

    public static class ModuleInstallationOptions {
        public static final Duration DEFAULT_TIMEOUT = Duration.ofMinutes(3L);
        public static final Duration DEFAULT_CHECK_INTERVAL = Duration.ofSeconds(5L);
        private Duration timeout;
        private Duration checkInterval;

        @Generated
        private static Duration $default$timeout() {
            return DEFAULT_TIMEOUT;
        }

        @Generated
        private static Duration $default$checkInterval() {
            return DEFAULT_CHECK_INTERVAL;
        }

        @Generated
        ModuleInstallationOptions(Duration timeout, Duration checkInterval) {
            this.timeout = timeout;
            this.checkInterval = checkInterval;
        }

        @Generated
        public static ModuleInstallationOptionsBuilder builder() {
            return new ModuleInstallationOptionsBuilder();
        }

        @Generated
        public Duration getTimeout() {
            return this.timeout;
        }

        @Generated
        public Duration getCheckInterval() {
            return this.checkInterval;
        }

        @Generated
        public void setTimeout(Duration timeout) {
            this.timeout = timeout;
        }

        @Generated
        public void setCheckInterval(Duration checkInterval) {
            this.checkInterval = checkInterval;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModuleInstallationOptions)) {
                return false;
            }
            ModuleInstallationOptions other = (ModuleInstallationOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Duration this$timeout = this.getTimeout();
            Duration other$timeout = other.getTimeout();
            if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
                return false;
            }
            Duration this$checkInterval = this.getCheckInterval();
            Duration other$checkInterval = other.getCheckInterval();
            return !(this$checkInterval == null ? other$checkInterval != null : !((Object)this$checkInterval).equals(other$checkInterval));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ModuleInstallationOptions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Duration $timeout = this.getTimeout();
            result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
            Duration $checkInterval = this.getCheckInterval();
            result = result * 59 + ($checkInterval == null ? 43 : ((Object)$checkInterval).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DatabaseProvisioner.ModuleInstallationOptions(timeout=" + this.getTimeout() + ", checkInterval=" + this.getCheckInterval() + ")";
        }

        @Generated
        public static class ModuleInstallationOptionsBuilder {
            @Generated
            private boolean timeout$set;
            @Generated
            private Duration timeout$value;
            @Generated
            private boolean checkInterval$set;
            @Generated
            private Duration checkInterval$value;

            @Generated
            ModuleInstallationOptionsBuilder() {
            }

            @Generated
            public ModuleInstallationOptionsBuilder timeout(Duration timeout) {
                this.timeout$value = timeout;
                this.timeout$set = true;
                return this;
            }

            @Generated
            public ModuleInstallationOptionsBuilder checkInterval(Duration checkInterval) {
                this.checkInterval$value = checkInterval;
                this.checkInterval$set = true;
                return this;
            }

            @Generated
            public ModuleInstallationOptions build() {
                Duration timeout$value = this.timeout$value;
                if (!this.timeout$set) {
                    timeout$value = ModuleInstallationOptions.$default$timeout();
                }
                Duration checkInterval$value = this.checkInterval$value;
                if (!this.checkInterval$set) {
                    checkInterval$value = ModuleInstallationOptions.$default$checkInterval();
                }
                return new ModuleInstallationOptions(timeout$value, checkInterval$value);
            }

            @Generated
            public String toString() {
                return "DatabaseProvisioner.ModuleInstallationOptions.ModuleInstallationOptionsBuilder(timeout$value=" + this.timeout$value + ", checkInterval$value=" + this.checkInterval$value + ")";
            }
        }
    }

    public static class PingOptions {
        public static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(10L);
        public static final Duration DEFAULT_INTERVAL = Duration.ofSeconds(1L);
        private Duration timeout;
        private Duration interval;

        @Generated
        private static Duration $default$timeout() {
            return DEFAULT_TIMEOUT;
        }

        @Generated
        private static Duration $default$interval() {
            return DEFAULT_INTERVAL;
        }

        @Generated
        PingOptions(Duration timeout, Duration interval) {
            this.timeout = timeout;
            this.interval = interval;
        }

        @Generated
        public static PingOptionsBuilder builder() {
            return new PingOptionsBuilder();
        }

        @Generated
        public Duration getTimeout() {
            return this.timeout;
        }

        @Generated
        public Duration getInterval() {
            return this.interval;
        }

        @Generated
        public void setTimeout(Duration timeout) {
            this.timeout = timeout;
        }

        @Generated
        public void setInterval(Duration interval) {
            this.interval = interval;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PingOptions)) {
                return false;
            }
            PingOptions other = (PingOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Duration this$timeout = this.getTimeout();
            Duration other$timeout = other.getTimeout();
            if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
                return false;
            }
            Duration this$interval = this.getInterval();
            Duration other$interval = other.getInterval();
            return !(this$interval == null ? other$interval != null : !((Object)this$interval).equals(other$interval));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PingOptions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Duration $timeout = this.getTimeout();
            result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
            Duration $interval = this.getInterval();
            result = result * 59 + ($interval == null ? 43 : ((Object)$interval).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DatabaseProvisioner.PingOptions(timeout=" + this.getTimeout() + ", interval=" + this.getInterval() + ")";
        }

        @Generated
        public static class PingOptionsBuilder {
            @Generated
            private boolean timeout$set;
            @Generated
            private Duration timeout$value;
            @Generated
            private boolean interval$set;
            @Generated
            private Duration interval$value;

            @Generated
            PingOptionsBuilder() {
            }

            @Generated
            public PingOptionsBuilder timeout(Duration timeout) {
                this.timeout$value = timeout;
                this.timeout$set = true;
                return this;
            }

            @Generated
            public PingOptionsBuilder interval(Duration interval) {
                this.interval$value = interval;
                this.interval$set = true;
                return this;
            }

            @Generated
            public PingOptions build() {
                Duration timeout$value = this.timeout$value;
                if (!this.timeout$set) {
                    timeout$value = PingOptions.$default$timeout();
                }
                Duration interval$value = this.interval$value;
                if (!this.interval$set) {
                    interval$value = PingOptions.$default$interval();
                }
                return new PingOptions(timeout$value, interval$value);
            }

            @Generated
            public String toString() {
                return "DatabaseProvisioner.PingOptions.PingOptionsBuilder(timeout$value=" + this.timeout$value + ", interval$value=" + this.interval$value + ")";
            }
        }
    }

    public static class Options {
        private PingOptions ping;
        private ModuleInstallationOptions moduleInstallation;

        @Generated
        private static PingOptions $default$ping() {
            return PingOptions.builder().build();
        }

        @Generated
        private static ModuleInstallationOptions $default$moduleInstallation() {
            return ModuleInstallationOptions.builder().build();
        }

        @Generated
        Options(PingOptions ping, ModuleInstallationOptions moduleInstallation) {
            this.ping = ping;
            this.moduleInstallation = moduleInstallation;
        }

        @Generated
        public static OptionsBuilder builder() {
            return new OptionsBuilder();
        }

        @Generated
        public PingOptions getPing() {
            return this.ping;
        }

        @Generated
        public ModuleInstallationOptions getModuleInstallation() {
            return this.moduleInstallation;
        }

        @Generated
        public void setPing(PingOptions ping) {
            this.ping = ping;
        }

        @Generated
        public void setModuleInstallation(ModuleInstallationOptions moduleInstallation) {
            this.moduleInstallation = moduleInstallation;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Options)) {
                return false;
            }
            Options other = (Options)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PingOptions this$ping = this.getPing();
            PingOptions other$ping = other.getPing();
            if (this$ping == null ? other$ping != null : !((Object)this$ping).equals(other$ping)) {
                return false;
            }
            ModuleInstallationOptions this$moduleInstallation = this.getModuleInstallation();
            ModuleInstallationOptions other$moduleInstallation = other.getModuleInstallation();
            return !(this$moduleInstallation == null ? other$moduleInstallation != null : !((Object)this$moduleInstallation).equals(other$moduleInstallation));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Options;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PingOptions $ping = this.getPing();
            result = result * 59 + ($ping == null ? 43 : ((Object)$ping).hashCode());
            ModuleInstallationOptions $moduleInstallation = this.getModuleInstallation();
            result = result * 59 + ($moduleInstallation == null ? 43 : ((Object)$moduleInstallation).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DatabaseProvisioner.Options(ping=" + this.getPing() + ", moduleInstallation=" + this.getModuleInstallation() + ")";
        }

        @Generated
        public static class OptionsBuilder {
            @Generated
            private boolean ping$set;
            @Generated
            private PingOptions ping$value;
            @Generated
            private boolean moduleInstallation$set;
            @Generated
            private ModuleInstallationOptions moduleInstallation$value;

            @Generated
            OptionsBuilder() {
            }

            @Generated
            public OptionsBuilder ping(PingOptions ping) {
                this.ping$value = ping;
                this.ping$set = true;
                return this;
            }

            @Generated
            public OptionsBuilder moduleInstallation(ModuleInstallationOptions moduleInstallation) {
                this.moduleInstallation$value = moduleInstallation;
                this.moduleInstallation$set = true;
                return this;
            }

            @Generated
            public Options build() {
                PingOptions ping$value = this.ping$value;
                if (!this.ping$set) {
                    ping$value = Options.$default$ping();
                }
                ModuleInstallationOptions moduleInstallation$value = this.moduleInstallation$value;
                if (!this.moduleInstallation$set) {
                    moduleInstallation$value = Options.$default$moduleInstallation();
                }
                return new Options(ping$value, moduleInstallation$value);
            }

            @Generated
            public String toString() {
                return "DatabaseProvisioner.Options.OptionsBuilder(ping$value=" + this.ping$value + ", moduleInstallation$value=" + this.moduleInstallation$value + ")";
            }
        }
    }

    public static class DatabaseProvisionerBuilder {
        private final RestAPI restAPI;
        private Options options = Options.builder().build();

        public DatabaseProvisionerBuilder(RestAPI restAPI) {
            this.restAPI = restAPI;
        }

        public DatabaseProvisioner build() {
            return new DatabaseProvisioner(this.restAPI, this.options);
        }

        @Generated
        public DatabaseProvisionerBuilder options(Options options) {
            this.options = options;
            return this;
        }
    }
}

