/*
 * Decompiled with CFR 0.152.
 */
package com.redis.testcontainers.support.enterprise;

import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.auth.AuthScheme;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.auth.Credentials;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.classic.methods.HttpGet;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.classic.methods.HttpPost;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.entity.mime.ByteArrayBody;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.entity.mime.ContentBody;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.impl.auth.BasicScheme;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.impl.classic.HttpClients;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.io.HttpClientConnectionManager;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.protocol.HttpClientContext;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.ssl.TrustAllStrategy;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.ClassicHttpRequest;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.ContentType;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.HttpEntity;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.HttpException;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.HttpHost;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.io.entity.EntityUtils;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.io.entity.StringEntity;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.protocol.HttpContext;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.ssl.SSLContexts;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.ssl.TrustStrategy;
import com.redis.testcontainers.support.enterprise.rest.ActionStatus;
import com.redis.testcontainers.support.enterprise.rest.Bootstrap;
import com.redis.testcontainers.support.enterprise.rest.Command;
import com.redis.testcontainers.support.enterprise.rest.CommandResponse;
import com.redis.testcontainers.support.enterprise.rest.Database;
import com.redis.testcontainers.support.enterprise.rest.DatabaseCreateResponse;
import com.redis.testcontainers.support.enterprise.rest.Module;
import com.redis.testcontainers.support.enterprise.rest.ModuleInstallResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.JavaType;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.type.SimpleType;

public class RestAPI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestAPI.class);
    public static final Object CONTENT_TYPE_JSON = "application/json";
    public static final String V1 = "/v1/";
    public static final String V2 = "/v2/";
    public static final String DEFAULT_PROTOCOL = "https";
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 9443;
    public static final String BOOTSTRAP = "bootstrap";
    public static final String ACTIONS = "actions";
    public static final String MODULES = "modules";
    public static final String BDBS = "bdbs";
    public static final String COMMAND = "command";
    private static final CharSequence PATH_SEPARATOR = "/";
    private UsernamePasswordCredentials credentials;
    private String protocol;
    private String host;
    private int port;
    private final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    private static String v1(String ... segments) {
        return RestAPI.join(V1, segments);
    }

    private static String v2(String ... segments) {
        return RestAPI.join(V2, segments);
    }

    private static String join(String path, String[] segments) {
        return path + String.join(PATH_SEPARATOR, segments);
    }

    private URI uri(String path) throws URISyntaxException {
        return new URI(this.protocol, null, this.host, this.port, path, null, null);
    }

    private <T> T get(String path, Class<T> type) throws Exception {
        return this.get(path, (JavaType)SimpleType.constructUnsafe(type));
    }

    private <T> T get(String path, JavaType type) throws Exception {
        return this.read((ClassicHttpRequest)new HttpGet(this.uri(path)), type);
    }

    private <T> T post(String path, Object request, Class<T> responseType) throws Exception {
        return this.post(path, request, (JavaType)SimpleType.constructUnsafe(responseType));
    }

    private <T> T post(String path, Object request, JavaType responseType) throws Exception {
        HttpPost post = new HttpPost(this.uri(path));
        String json = this.objectMapper.writeValueAsString(request);
        post.setEntity((HttpEntity)new StringEntity(json));
        log.info("POST {}", (Object)json);
        return this.read((ClassicHttpRequest)post, responseType);
    }

    private <T> T read(ClassicHttpRequest request, JavaType type) throws Exception {
        request.setHeader("Content-Type", CONTENT_TYPE_JSON);
        return this.read(request, type, 200);
    }

    private <T> T read(ClassicHttpRequest request, Class<T> type, int successCode) throws Exception {
        return this.read(request, (JavaType)SimpleType.constructUnsafe(type), successCode);
    }

    private <T> T read(ClassicHttpRequest request, JavaType type, int successCode) throws Exception {
        try (CloseableHttpClient client = this.client();){
            CloseableHttpResponse response = this.execute(request, client);
            if (response.getCode() == successCode) {
                Object object = this.objectMapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), type);
                return (T)object;
            }
            throw new HttpException(response.getCode() + ": " + EntityUtils.toString((HttpEntity)response.getEntity()));
        }
    }

    private CloseableHttpResponse execute(ClassicHttpRequest request, CloseableHttpClient client) throws IOException {
        HttpHost target = new HttpHost(this.protocol, this.host, this.port);
        HttpClientContext localContext = HttpClientContext.create();
        if (this.credentials != null) {
            BasicScheme basicAuth = new BasicScheme();
            basicAuth.initPreemptive((Credentials)this.credentials);
            localContext.resetAuthExchange(target, (AuthScheme)basicAuth);
        }
        return client.execute(request, (HttpContext)localContext);
    }

    private CloseableHttpClient client() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustAllStrategy()).build();
        SSLConnectionSocketFactory sslSocketFactory = SSLConnectionSocketFactoryBuilder.create().setSslContext(sslcontext).setHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build();
        PoolingHttpClientConnectionManager cm = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).build();
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
    }

    public List<Module> modules() throws Exception {
        return (List)this.get(RestAPI.v1(MODULES), (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, Module.class));
    }

    public DatabaseCreateResponse create(Database database) throws Exception {
        return this.post(RestAPI.v1(BDBS), (Object)database, DatabaseCreateResponse.class);
    }

    public ModuleInstallResponse module(String filename, byte[] bytes) throws Exception {
        HttpPost post = new HttpPost(this.uri(RestAPI.v2(MODULES)));
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.STRICT);
        builder.addPart("module", (ContentBody)new ByteArrayBody(bytes, ContentType.MULTIPART_FORM_DATA, filename));
        post.setEntity(builder.build());
        return this.read((ClassicHttpRequest)post, ModuleInstallResponse.class, 202);
    }

    public Bootstrap bootstrap() throws Exception {
        return this.get(RestAPI.v1(BOOTSTRAP), Bootstrap.class);
    }

    public ActionStatus actionStatus(String actionUID) throws Exception {
        return this.get(RestAPI.v1(ACTIONS, actionUID), ActionStatus.class);
    }

    public CommandResponse command(long bdb, Command command) throws Exception {
        return this.post(RestAPI.v1(BDBS, String.valueOf(bdb), COMMAND), (Object)command, CommandResponse.class);
    }

    @Generated
    private static String $default$protocol() {
        return DEFAULT_PROTOCOL;
    }

    @Generated
    private static String $default$host() {
        return DEFAULT_HOST;
    }

    @Generated
    private static int $default$port() {
        return 9443;
    }

    @Generated
    RestAPI(UsernamePasswordCredentials credentials, String protocol, String host, int port) {
        this.credentials = credentials;
        this.protocol = protocol;
        this.host = host;
        this.port = port;
    }

    @Generated
    public static RestAPIBuilder builder() {
        return new RestAPIBuilder();
    }

    @Generated
    public UsernamePasswordCredentials getCredentials() {
        return this.credentials;
    }

    @Generated
    public String getProtocol() {
        return this.protocol;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public void setCredentials(UsernamePasswordCredentials credentials) {
        this.credentials = credentials;
    }

    @Generated
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestAPI)) {
            return false;
        }
        RestAPI other = (RestAPI)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        UsernamePasswordCredentials this$credentials = this.getCredentials();
        UsernamePasswordCredentials other$credentials = other.getCredentials();
        if (this$credentials == null ? other$credentials != null : !this$credentials.equals(other$credentials)) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        ObjectMapper this$objectMapper = this.getObjectMapper();
        ObjectMapper other$objectMapper = other.getObjectMapper();
        return !(this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RestAPI;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        UsernamePasswordCredentials $credentials = this.getCredentials();
        result = result * 59 + ($credentials == null ? 43 : $credentials.hashCode());
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        ObjectMapper $objectMapper = this.getObjectMapper();
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RestAPI(credentials=" + this.getCredentials() + ", protocol=" + this.getProtocol() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", objectMapper=" + this.getObjectMapper() + ")";
    }

    @Generated
    public static class RestAPIBuilder {
        @Generated
        private UsernamePasswordCredentials credentials;
        @Generated
        private boolean protocol$set;
        @Generated
        private String protocol$value;
        @Generated
        private boolean host$set;
        @Generated
        private String host$value;
        @Generated
        private boolean port$set;
        @Generated
        private int port$value;

        @Generated
        RestAPIBuilder() {
        }

        @Generated
        public RestAPIBuilder credentials(UsernamePasswordCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        @Generated
        public RestAPIBuilder protocol(String protocol) {
            this.protocol$value = protocol;
            this.protocol$set = true;
            return this;
        }

        @Generated
        public RestAPIBuilder host(String host) {
            this.host$value = host;
            this.host$set = true;
            return this;
        }

        @Generated
        public RestAPIBuilder port(int port) {
            this.port$value = port;
            this.port$set = true;
            return this;
        }

        @Generated
        public RestAPI build() {
            String protocol$value = this.protocol$value;
            if (!this.protocol$set) {
                protocol$value = RestAPI.$default$protocol();
            }
            String host$value = this.host$value;
            if (!this.host$set) {
                host$value = RestAPI.$default$host();
            }
            int port$value = this.port$value;
            if (!this.port$set) {
                port$value = RestAPI.$default$port();
            }
            return new RestAPI(this.credentials, protocol$value, host$value, port$value);
        }

        @Generated
        public String toString() {
            return "RestAPI.RestAPIBuilder(credentials=" + this.credentials + ", protocol$value=" + this.protocol$value + ", host$value=" + this.host$value + ", port$value=" + this.port$value + ")";
        }
    }
}

