/*
 * Decompiled with CFR 0.152.
 */
package com.redis.testcontainers.support.enterprise.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Database {
    private String name;
    private Boolean replication;
    private Boolean sharding;
    @JsonProperty(value="memory_size")
    private long memory;
    private Integer port;
    private String type;
    @JsonProperty(value="oss_cluster")
    private Boolean ossCluster;
    @JsonProperty(value="proxy_policy")
    private ProxyPolicy proxyPolicy;
    @JsonProperty(value="oss_cluster_api_preferred_ip_type")
    private IPType ossClusterAPIPreferredIPType;
    @JsonProperty(value="shard_key_regex")
    private List<Regex> shardKeyRegex;
    @JsonProperty(value="shards_count")
    private Integer shardCount;
    @JsonProperty(value="shards_placement")
    private ShardPlacement shardPlacement;
    @JsonProperty(value="module_list")
    private List<ModuleConfig> moduleConfigs;

    private static DatabaseBuilder builder() {
        return new DatabaseBuilder();
    }

    public static DatabaseBuilder name(String name) {
        return new DatabaseBuilder(name);
    }

    @Generated
    private static long $default$memory() {
        return 520428800L;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getReplication() {
        return this.replication;
    }

    @Generated
    public Boolean getSharding() {
        return this.sharding;
    }

    @Generated
    public long getMemory() {
        return this.memory;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Boolean getOssCluster() {
        return this.ossCluster;
    }

    @Generated
    public ProxyPolicy getProxyPolicy() {
        return this.proxyPolicy;
    }

    @Generated
    public IPType getOssClusterAPIPreferredIPType() {
        return this.ossClusterAPIPreferredIPType;
    }

    @Generated
    public List<Regex> getShardKeyRegex() {
        return this.shardKeyRegex;
    }

    @Generated
    public Integer getShardCount() {
        return this.shardCount;
    }

    @Generated
    public ShardPlacement getShardPlacement() {
        return this.shardPlacement;
    }

    @Generated
    public List<ModuleConfig> getModuleConfigs() {
        return this.moduleConfigs;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setReplication(Boolean replication) {
        this.replication = replication;
    }

    @Generated
    public void setSharding(Boolean sharding) {
        this.sharding = sharding;
    }

    @JsonProperty(value="memory_size")
    @Generated
    public void setMemory(long memory) {
        this.memory = memory;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="oss_cluster")
    @Generated
    public void setOssCluster(Boolean ossCluster) {
        this.ossCluster = ossCluster;
    }

    @JsonProperty(value="proxy_policy")
    @Generated
    public void setProxyPolicy(ProxyPolicy proxyPolicy) {
        this.proxyPolicy = proxyPolicy;
    }

    @JsonProperty(value="oss_cluster_api_preferred_ip_type")
    @Generated
    public void setOssClusterAPIPreferredIPType(IPType ossClusterAPIPreferredIPType) {
        this.ossClusterAPIPreferredIPType = ossClusterAPIPreferredIPType;
    }

    @JsonProperty(value="shard_key_regex")
    @Generated
    public void setShardKeyRegex(List<Regex> shardKeyRegex) {
        this.shardKeyRegex = shardKeyRegex;
    }

    @JsonProperty(value="shards_count")
    @Generated
    public void setShardCount(Integer shardCount) {
        this.shardCount = shardCount;
    }

    @JsonProperty(value="shards_placement")
    @Generated
    public void setShardPlacement(ShardPlacement shardPlacement) {
        this.shardPlacement = shardPlacement;
    }

    @JsonProperty(value="module_list")
    @Generated
    public void setModuleConfigs(List<ModuleConfig> moduleConfigs) {
        this.moduleConfigs = moduleConfigs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Database)) {
            return false;
        }
        Database other = (Database)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMemory() != other.getMemory()) {
            return false;
        }
        Boolean this$replication = this.getReplication();
        Boolean other$replication = other.getReplication();
        if (this$replication == null ? other$replication != null : !((Object)this$replication).equals(other$replication)) {
            return false;
        }
        Boolean this$sharding = this.getSharding();
        Boolean other$sharding = other.getSharding();
        if (this$sharding == null ? other$sharding != null : !((Object)this$sharding).equals(other$sharding)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Boolean this$ossCluster = this.getOssCluster();
        Boolean other$ossCluster = other.getOssCluster();
        if (this$ossCluster == null ? other$ossCluster != null : !((Object)this$ossCluster).equals(other$ossCluster)) {
            return false;
        }
        Integer this$shardCount = this.getShardCount();
        Integer other$shardCount = other.getShardCount();
        if (this$shardCount == null ? other$shardCount != null : !((Object)this$shardCount).equals(other$shardCount)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        ProxyPolicy this$proxyPolicy = this.getProxyPolicy();
        ProxyPolicy other$proxyPolicy = other.getProxyPolicy();
        if (this$proxyPolicy == null ? other$proxyPolicy != null : !((Object)((Object)this$proxyPolicy)).equals((Object)other$proxyPolicy)) {
            return false;
        }
        IPType this$ossClusterAPIPreferredIPType = this.getOssClusterAPIPreferredIPType();
        IPType other$ossClusterAPIPreferredIPType = other.getOssClusterAPIPreferredIPType();
        if (this$ossClusterAPIPreferredIPType == null ? other$ossClusterAPIPreferredIPType != null : !((Object)((Object)this$ossClusterAPIPreferredIPType)).equals((Object)other$ossClusterAPIPreferredIPType)) {
            return false;
        }
        List<Regex> this$shardKeyRegex = this.getShardKeyRegex();
        List<Regex> other$shardKeyRegex = other.getShardKeyRegex();
        if (this$shardKeyRegex == null ? other$shardKeyRegex != null : !((Object)this$shardKeyRegex).equals(other$shardKeyRegex)) {
            return false;
        }
        ShardPlacement this$shardPlacement = this.getShardPlacement();
        ShardPlacement other$shardPlacement = other.getShardPlacement();
        if (this$shardPlacement == null ? other$shardPlacement != null : !((Object)((Object)this$shardPlacement)).equals((Object)other$shardPlacement)) {
            return false;
        }
        List<ModuleConfig> this$moduleConfigs = this.getModuleConfigs();
        List<ModuleConfig> other$moduleConfigs = other.getModuleConfigs();
        return !(this$moduleConfigs == null ? other$moduleConfigs != null : !((Object)this$moduleConfigs).equals(other$moduleConfigs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Database;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $memory = this.getMemory();
        result = result * 59 + (int)($memory >>> 32 ^ $memory);
        Boolean $replication = this.getReplication();
        result = result * 59 + ($replication == null ? 43 : ((Object)$replication).hashCode());
        Boolean $sharding = this.getSharding();
        result = result * 59 + ($sharding == null ? 43 : ((Object)$sharding).hashCode());
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Boolean $ossCluster = this.getOssCluster();
        result = result * 59 + ($ossCluster == null ? 43 : ((Object)$ossCluster).hashCode());
        Integer $shardCount = this.getShardCount();
        result = result * 59 + ($shardCount == null ? 43 : ((Object)$shardCount).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        ProxyPolicy $proxyPolicy = this.getProxyPolicy();
        result = result * 59 + ($proxyPolicy == null ? 43 : ((Object)((Object)$proxyPolicy)).hashCode());
        IPType $ossClusterAPIPreferredIPType = this.getOssClusterAPIPreferredIPType();
        result = result * 59 + ($ossClusterAPIPreferredIPType == null ? 43 : ((Object)((Object)$ossClusterAPIPreferredIPType)).hashCode());
        List<Regex> $shardKeyRegex = this.getShardKeyRegex();
        result = result * 59 + ($shardKeyRegex == null ? 43 : ((Object)$shardKeyRegex).hashCode());
        ShardPlacement $shardPlacement = this.getShardPlacement();
        result = result * 59 + ($shardPlacement == null ? 43 : ((Object)((Object)$shardPlacement)).hashCode());
        List<ModuleConfig> $moduleConfigs = this.getModuleConfigs();
        result = result * 59 + ($moduleConfigs == null ? 43 : ((Object)$moduleConfigs).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Database(name=" + this.getName() + ", replication=" + this.getReplication() + ", sharding=" + this.getSharding() + ", memory=" + this.getMemory() + ", port=" + this.getPort() + ", type=" + this.getType() + ", ossCluster=" + this.getOssCluster() + ", proxyPolicy=" + (Object)((Object)this.getProxyPolicy()) + ", ossClusterAPIPreferredIPType=" + (Object)((Object)this.getOssClusterAPIPreferredIPType()) + ", shardKeyRegex=" + this.getShardKeyRegex() + ", shardCount=" + this.getShardCount() + ", shardPlacement=" + (Object)((Object)this.getShardPlacement()) + ", moduleConfigs=" + this.getModuleConfigs() + ")";
    }

    @Generated
    public Database() {
        this.memory = Database.$default$memory();
    }

    @Generated
    public Database(String name, Boolean replication, Boolean sharding, long memory, Integer port, String type, Boolean ossCluster, ProxyPolicy proxyPolicy, IPType ossClusterAPIPreferredIPType, List<Regex> shardKeyRegex, Integer shardCount, ShardPlacement shardPlacement, List<ModuleConfig> moduleConfigs) {
        this.name = name;
        this.replication = replication;
        this.sharding = sharding;
        this.memory = memory;
        this.port = port;
        this.type = type;
        this.ossCluster = ossCluster;
        this.proxyPolicy = proxyPolicy;
        this.ossClusterAPIPreferredIPType = ossClusterAPIPreferredIPType;
        this.shardKeyRegex = shardKeyRegex;
        this.shardCount = shardCount;
        this.shardPlacement = shardPlacement;
        this.moduleConfigs = moduleConfigs;
    }

    public static class DatabaseBuilder {
        @Generated
        private String name;
        @Generated
        private Boolean replication;
        @Generated
        private Boolean sharding;
        @Generated
        private boolean memory$set;
        @Generated
        private long memory$value;
        @Generated
        private Integer port;
        @Generated
        private String type;
        @Generated
        private Boolean ossCluster;
        @Generated
        private ProxyPolicy proxyPolicy;
        @Generated
        private IPType ossClusterAPIPreferredIPType;
        @Generated
        private List<Regex> shardKeyRegex;
        @Generated
        private Integer shardCount;
        @Generated
        private ShardPlacement shardPlacement;
        @Generated
        private ArrayList<ModuleConfig> moduleConfigs;
        public static final long DEFAULT_MEMORY = 520428800L;
        public static final int DEFAULT_CLUSTER_SHARD_COUNT = 3;
        public static final List<Regex> DEFAULT_SHARD_KEY_REGEX = Arrays.asList(Regex.of(".*\\{(?<tag>.*)\\}.*"), Regex.of("(?<tag>.*)"));

        public DatabaseBuilder modules(Module ... modules) {
            for (Module module : modules) {
                this.moduleConfig(ModuleConfig.builder().name(module.getName()).build());
            }
            return this;
        }

        private DatabaseBuilder() {
        }

        public DatabaseBuilder(String name) {
            this.name = name;
        }

        public DatabaseBuilder shardCount(int shardCount) {
            this.shardCount = shardCount;
            if (shardCount > 1) {
                this.sharding = true;
                this.shardKeyRegex = DEFAULT_SHARD_KEY_REGEX;
            }
            return this;
        }

        public DatabaseBuilder ossCluster(boolean ossCluster) {
            this.ossCluster = ossCluster;
            if (ossCluster) {
                this.proxyPolicy = ProxyPolicy.ALL_MASTER_SHARDS;
                this.ossClusterAPIPreferredIPType = IPType.EXTERNAL;
                if (this.shardCount == null || this.shardCount < 2) {
                    this.shardCount(3);
                }
            }
            return this;
        }

        @Generated
        public DatabaseBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public DatabaseBuilder replication(Boolean replication) {
            this.replication = replication;
            return this;
        }

        @Generated
        public DatabaseBuilder sharding(Boolean sharding) {
            this.sharding = sharding;
            return this;
        }

        @JsonProperty(value="memory_size")
        @Generated
        public DatabaseBuilder memory(long memory) {
            this.memory$value = memory;
            this.memory$set = true;
            return this;
        }

        @Generated
        public DatabaseBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        @Generated
        public DatabaseBuilder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="proxy_policy")
        @Generated
        public DatabaseBuilder proxyPolicy(ProxyPolicy proxyPolicy) {
            this.proxyPolicy = proxyPolicy;
            return this;
        }

        @JsonProperty(value="oss_cluster_api_preferred_ip_type")
        @Generated
        public DatabaseBuilder ossClusterAPIPreferredIPType(IPType ossClusterAPIPreferredIPType) {
            this.ossClusterAPIPreferredIPType = ossClusterAPIPreferredIPType;
            return this;
        }

        @JsonProperty(value="shard_key_regex")
        @Generated
        public DatabaseBuilder shardKeyRegex(List<Regex> shardKeyRegex) {
            this.shardKeyRegex = shardKeyRegex;
            return this;
        }

        @JsonProperty(value="shards_placement")
        @Generated
        public DatabaseBuilder shardPlacement(ShardPlacement shardPlacement) {
            this.shardPlacement = shardPlacement;
            return this;
        }

        @Generated
        public DatabaseBuilder moduleConfig(ModuleConfig moduleConfig) {
            if (this.moduleConfigs == null) {
                this.moduleConfigs = new ArrayList();
            }
            this.moduleConfigs.add(moduleConfig);
            return this;
        }

        @JsonProperty(value="module_list")
        @Generated
        public DatabaseBuilder moduleConfigs(Collection<? extends ModuleConfig> moduleConfigs) {
            if (moduleConfigs == null) {
                throw new NullPointerException("moduleConfigs cannot be null");
            }
            if (this.moduleConfigs == null) {
                this.moduleConfigs = new ArrayList();
            }
            this.moduleConfigs.addAll(moduleConfigs);
            return this;
        }

        @Generated
        public DatabaseBuilder clearModuleConfigs() {
            if (this.moduleConfigs != null) {
                this.moduleConfigs.clear();
            }
            return this;
        }

        @Generated
        public Database build() {
            List<ModuleConfig> moduleConfigs;
            switch (this.moduleConfigs == null ? 0 : this.moduleConfigs.size()) {
                case 0: {
                    moduleConfigs = Collections.emptyList();
                    break;
                }
                case 1: {
                    moduleConfigs = Collections.singletonList(this.moduleConfigs.get(0));
                    break;
                }
                default: {
                    moduleConfigs = Collections.unmodifiableList(new ArrayList<ModuleConfig>(this.moduleConfigs));
                }
            }
            long memory$value = this.memory$value;
            if (!this.memory$set) {
                memory$value = Database.$default$memory();
            }
            return new Database(this.name, this.replication, this.sharding, memory$value, this.port, this.type, this.ossCluster, this.proxyPolicy, this.ossClusterAPIPreferredIPType, this.shardKeyRegex, this.shardCount, this.shardPlacement, moduleConfigs);
        }

        @Generated
        public String toString() {
            return "Database.DatabaseBuilder(name=" + this.name + ", replication=" + this.replication + ", sharding=" + this.sharding + ", memory$value=" + this.memory$value + ", port=" + this.port + ", type=" + this.type + ", ossCluster=" + this.ossCluster + ", proxyPolicy=" + (Object)((Object)this.proxyPolicy) + ", ossClusterAPIPreferredIPType=" + (Object)((Object)this.ossClusterAPIPreferredIPType) + ", shardKeyRegex=" + this.shardKeyRegex + ", shardCount=" + this.shardCount + ", shardPlacement=" + (Object)((Object)this.shardPlacement) + ", moduleConfigs=" + this.moduleConfigs + ")";
        }
    }

    public static enum Module {
        BLOOM("bf"),
        GEARS("rg"),
        GRAPH("graph"),
        JSON("ReJSON"),
        SEARCH("search"),
        TIMESERIES("timeseries");

        private final String name;

        private Module(String name) {
            this.name = name;
        }

        @Generated
        public String getName() {
            return this.name;
        }
    }

    public static enum IPType {
        INTERNAL,
        EXTERNAL;

    }

    public static enum ProxyPolicy {
        SINGLE,
        ALL_MASTER_SHARDS,
        ALL_NODES;

    }

    public static enum ShardPlacement {
        DENSE,
        SPARSE;

    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Regex {
        private String regex;

        public static Regex of(String regex) {
            return new Regex(regex);
        }

        @Generated
        public String getRegex() {
            return this.regex;
        }

        @Generated
        public void setRegex(String regex) {
            this.regex = regex;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Regex)) {
                return false;
            }
            Regex other = (Regex)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$regex = this.getRegex();
            String other$regex = other.getRegex();
            return !(this$regex == null ? other$regex != null : !this$regex.equals(other$regex));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Regex;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $regex = this.getRegex();
            result = result * 59 + ($regex == null ? 43 : $regex.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Database.Regex(regex=" + this.getRegex() + ")";
        }

        @Generated
        public Regex() {
        }

        @Generated
        public Regex(String regex) {
            this.regex = regex;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class ModuleConfig {
        @JsonProperty(value="module_name")
        private String name;
        @JsonProperty(value="module_id")
        private String id;
        @JsonProperty(value="module_args")
        private String args;

        @Generated
        private static String $default$args() {
            return "";
        }

        @Generated
        public static ModuleConfigBuilder builder() {
            return new ModuleConfigBuilder();
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getArgs() {
            return this.args;
        }

        @JsonProperty(value="module_name")
        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="module_id")
        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="module_args")
        @Generated
        public void setArgs(String args) {
            this.args = args;
        }

        @Generated
        public String toString() {
            return "Database.ModuleConfig(name=" + this.getName() + ", id=" + this.getId() + ", args=" + this.getArgs() + ")";
        }

        @Generated
        public ModuleConfig() {
            this.args = ModuleConfig.$default$args();
        }

        @Generated
        public ModuleConfig(String name, String id, String args) {
            this.name = name;
            this.id = id;
            this.args = args;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModuleConfig)) {
                return false;
            }
            ModuleConfig other = (ModuleConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ModuleConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public static class ModuleConfigBuilder {
            @Generated
            private String name;
            @Generated
            private String id;
            @Generated
            private boolean args$set;
            @Generated
            private String args$value;

            @Generated
            ModuleConfigBuilder() {
            }

            @JsonProperty(value="module_name")
            @Generated
            public ModuleConfigBuilder name(String name) {
                this.name = name;
                return this;
            }

            @JsonProperty(value="module_id")
            @Generated
            public ModuleConfigBuilder id(String id) {
                this.id = id;
                return this;
            }

            @JsonProperty(value="module_args")
            @Generated
            public ModuleConfigBuilder args(String args) {
                this.args$value = args;
                this.args$set = true;
                return this;
            }

            @Generated
            public ModuleConfig build() {
                String args$value = this.args$value;
                if (!this.args$set) {
                    args$value = ModuleConfig.$default$args();
                }
                return new ModuleConfig(this.name, this.id, args$value);
            }

            @Generated
            public String toString() {
                return "Database.ModuleConfig.ModuleConfigBuilder(name=" + this.name + ", id=" + this.id + ", args$value=" + this.args$value + ")";
            }
        }
    }
}

