/*
 * Decompiled with CFR 0.152.
 */
package com.redis.testcontainers.support.enterprise.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.util.Asserts;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DatabaseCreateRequest {
    public static final long DEFAULT_MEMORY = 520428800L;
    public static final int DEFAULT_CLUSTER_SHARD_COUNT = 3;
    public static final List<Regex> DEFAULT_SHARD_KEY_REGEX = Arrays.asList(new Regex(".*\\{(?<tag>.*)\\}.*"), new Regex("(?<tag>.*)"));
    private String name;
    private Boolean replication;
    private Boolean sharding;
    private long memory = 520428800L;
    private Integer port;
    private String type;
    private Boolean ossCluster;
    private ProxyPolicy proxyPolicy;
    private IPType ossClusterAPIPreferredIPType;
    private List<Regex> shardKeyRegex = new ArrayList<Regex>();
    private Integer shardCount;
    private ShardPlacement shardPlacement;
    private List<ModuleConfig> moduleConfigs = new ArrayList<ModuleConfig>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getReplication() {
        return this.replication;
    }

    public void setReplication(boolean replication) {
        this.replication = replication;
    }

    public Boolean getSharding() {
        return this.sharding;
    }

    public void setSharding(boolean sharding) {
        this.sharding = sharding;
    }

    @JsonProperty(value="memory_size")
    public long getMemory() {
        return this.memory;
    }

    public void setMemory(long memory) {
        this.memory = memory;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="oss_cluster")
    public Boolean getOssCluster() {
        return this.ossCluster;
    }

    public void setOssCluster(boolean ossCluster) {
        this.ossCluster = ossCluster;
        if (ossCluster) {
            this.proxyPolicy = ProxyPolicy.ALL_MASTER_SHARDS;
            this.ossClusterAPIPreferredIPType = IPType.EXTERNAL;
            if (this.shardCount == null || this.shardCount < 2) {
                this.setShardCount(3);
            }
        }
    }

    @JsonProperty(value="proxy_policy")
    public ProxyPolicy getProxyPolicy() {
        return this.proxyPolicy;
    }

    public void setProxyPolicy(ProxyPolicy proxyPolicy) {
        this.proxyPolicy = proxyPolicy;
    }

    @JsonProperty(value="oss_cluster_api_preferred_ip_type")
    public IPType getOssClusterAPIPreferredIPType() {
        return this.ossClusterAPIPreferredIPType;
    }

    public void setOssClusterAPIPreferredIPType(IPType ossClusterAPIPreferredIPType) {
        this.ossClusterAPIPreferredIPType = ossClusterAPIPreferredIPType;
    }

    @JsonProperty(value="shard_key_regex")
    public List<Regex> getShardKeyRegex() {
        return this.shardKeyRegex;
    }

    public void setShardKeyRegex(List<Regex> shardKeyRegex) {
        this.shardKeyRegex = shardKeyRegex;
    }

    @JsonProperty(value="shards_count")
    public Integer getShardCount() {
        return this.shardCount;
    }

    public void setShardCount(int shardCount) {
        Asserts.check((shardCount > 0 ? 1 : 0) != 0, (String)"Shard count must be strictly positive");
        this.shardCount = shardCount;
        if (shardCount > 1) {
            this.sharding = true;
            this.shardKeyRegex = DEFAULT_SHARD_KEY_REGEX;
        }
    }

    @JsonProperty(value="shards_placement")
    public ShardPlacement getShardPlacement() {
        return this.shardPlacement;
    }

    public void setShardPlacement(ShardPlacement shardPlacement) {
        this.shardPlacement = shardPlacement;
    }

    @JsonProperty(value="module_list")
    public List<ModuleConfig> getModuleConfigs() {
        return this.moduleConfigs;
    }

    public void setModuleConfigs(List<ModuleConfig> moduleConfigs) {
        this.moduleConfigs = moduleConfigs;
    }

    public void setModules(List<String> names) {
        this.setModuleConfigs(names.stream().map(ModuleConfig::new).collect(Collectors.toList()));
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Regex {
        private String regex;

        public Regex() {
        }

        public Regex(String regex) {
            this.regex = regex;
        }

        public String getRegex() {
            return this.regex;
        }

        public void setRegex(String regex) {
            this.regex = regex;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class ModuleConfig {
        private String name;
        private String id;
        private String args = "";

        public ModuleConfig() {
        }

        public ModuleConfig(String name) {
            this.name = name;
        }

        @JsonProperty(value="module_name")
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="module_id")
        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="module_args")
        public String getArgs() {
            return this.args;
        }

        public void setArgs(String args) {
            this.args = args;
        }
    }

    public static enum ShardPlacement {
        DENSE,
        SPARSE;

    }

    public static enum ProxyPolicy {
        SINGLE,
        ALL_MASTER_SHARDS,
        ALL_NODES;

    }

    public static enum IPType {
        INTERNAL,
        EXTERNAL;

    }
}

